/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.platform.spi;

import com.digiwin.apollo.platform.build.ApolloInjector;
import com.digiwin.apollo.platform.spi.ConfigFactory;
import com.digiwin.apollo.platform.spi.ConfigFactoryManager;
import com.digiwin.apollo.platform.spi.ConfigRegistry;
import com.google.common.collect.Maps;
import java.util.Map;

public class DefaultConfigFactoryManager
implements ConfigFactoryManager {
    private ConfigRegistry m_registry;
    private Map<String, ConfigFactory> m_factories = Maps.newConcurrentMap();

    public DefaultConfigFactoryManager() {
        this.m_registry = ApolloInjector.getInstance(ConfigRegistry.class);
    }

    @Override
    public ConfigFactory getFactory(String namespace) {
        ConfigFactory factory = this.m_registry.getFactory(namespace);
        if (factory != null) {
            return factory;
        }
        factory = this.m_factories.get(namespace);
        if (factory != null) {
            return factory;
        }
        factory = ApolloInjector.getInstance(ConfigFactory.class, namespace);
        if (factory != null) {
            return factory;
        }
        factory = ApolloInjector.getInstance(ConfigFactory.class);
        this.m_factories.put(namespace, factory);
        return factory;
    }
}

