/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.application;

import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.digiwin.apollo.application.ApplicationConfig;
import com.digiwin.apollo.application.ApplicationConfigFile;
import com.digiwin.apollo.application.build.ApolloInjector;
import com.digiwin.apollo.application.internals.ConfigManager;
import com.digiwin.apollo.application.spi.ConfigFactory;
import com.digiwin.apollo.application.spi.ConfigRegistry;

public class ApplicationConfigService {
    private static final ApplicationConfigService s_instance = new ApplicationConfigService();
    private volatile ConfigManager m_configManager;
    private volatile ConfigRegistry m_configRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigManager getManager() {
        if (this.m_configManager == null) {
            ApplicationConfigService applicationConfigService = this;
            synchronized (applicationConfigService) {
                if (this.m_configManager == null) {
                    this.m_configManager = ApolloInjector.getInstance(ConfigManager.class);
                }
            }
        }
        return this.m_configManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigRegistry getRegistry() {
        if (this.m_configRegistry == null) {
            ApplicationConfigService applicationConfigService = this;
            synchronized (applicationConfigService) {
                if (this.m_configRegistry == null) {
                    this.m_configRegistry = ApolloInjector.getInstance(ConfigRegistry.class);
                }
            }
        }
        return this.m_configRegistry;
    }

    public static ApplicationConfig getAppConfig() {
        return ApplicationConfigService.getConfig("application");
    }

    public static ApplicationConfig getConfig(String namespace) {
        return s_instance.getManager().getConfig(namespace);
    }

    public static ApplicationConfigFile getConfigFile(String namespace, ConfigFileFormat configFileFormat) {
        return s_instance.getManager().getConfigFile(namespace, configFileFormat);
    }

    static void setConfig(ApplicationConfig config) {
        ApplicationConfigService.setConfig("application", config);
    }

    static void setConfig(String namespace, final ApplicationConfig config) {
        s_instance.getRegistry().register(namespace, new ConfigFactory(){

            @Override
            public ApplicationConfig create(String namespace) {
                return config;
            }

            @Override
            public ApplicationConfigFile createConfigFile(String namespace, ConfigFileFormat configFileFormat) {
                return null;
            }
        });
    }

    static void setConfigFactory(ConfigFactory factory) {
        ApplicationConfigService.setConfigFactory("application", factory);
    }

    static void setConfigFactory(String namespace, ConfigFactory factory) {
        s_instance.getRegistry().register(namespace, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        ApplicationConfigService applicationConfigService = s_instance;
        synchronized (applicationConfigService) {
            ApplicationConfigService.s_instance.m_configManager = null;
            ApplicationConfigService.s_instance.m_configRegistry = null;
        }
    }
}

