/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.group;

import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.digiwin.apollo.group.GroupConfig;
import com.digiwin.apollo.group.GroupConfigFile;
import com.digiwin.apollo.group.build.ApolloInjector;
import com.digiwin.apollo.group.internals.ConfigManager;
import com.digiwin.apollo.group.spi.ConfigFactory;
import com.digiwin.apollo.group.spi.ConfigRegistry;

public class GroupConfigService {
    private static final GroupConfigService s_instance = new GroupConfigService();
    private volatile ConfigManager m_configManager;
    private volatile ConfigRegistry m_configRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigManager getManager() {
        if (this.m_configManager == null) {
            GroupConfigService groupConfigService = this;
            synchronized (groupConfigService) {
                if (this.m_configManager == null) {
                    this.m_configManager = ApolloInjector.getInstance(ConfigManager.class);
                }
            }
        }
        return this.m_configManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigRegistry getRegistry() {
        if (this.m_configRegistry == null) {
            GroupConfigService groupConfigService = this;
            synchronized (groupConfigService) {
                if (this.m_configRegistry == null) {
                    this.m_configRegistry = ApolloInjector.getInstance(ConfigRegistry.class);
                }
            }
        }
        return this.m_configRegistry;
    }

    public static GroupConfig getAppConfig() {
        return GroupConfigService.getConfig("application");
    }

    public static GroupConfig getConfig(String namespace) {
        return s_instance.getManager().getConfig(namespace);
    }

    public static GroupConfigFile getConfigFile(String namespace, ConfigFileFormat configFileFormat) {
        return s_instance.getManager().getConfigFile(namespace, configFileFormat);
    }

    static void setConfig(GroupConfig config) {
        GroupConfigService.setConfig("application", config);
    }

    static void setConfig(String namespace, final GroupConfig config) {
        s_instance.getRegistry().register(namespace, new ConfigFactory(){

            @Override
            public GroupConfig create(String namespace) {
                return config;
            }

            @Override
            public GroupConfigFile createConfigFile(String namespace, ConfigFileFormat configFileFormat) {
                return null;
            }
        });
    }

    static void setConfigFactory(ConfigFactory factory) {
        GroupConfigService.setConfigFactory("application", factory);
    }

    static void setConfigFactory(String namespace, ConfigFactory factory) {
        s_instance.getRegistry().register(namespace, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        GroupConfigService groupConfigService = s_instance;
        synchronized (groupConfigService) {
            GroupConfigService.s_instance.m_configManager = null;
            GroupConfigService.s_instance.m_configRegistry = null;
        }
    }
}

