/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.group.spring.util;

import com.ctrip.framework.apollo.tracer.Tracer;
import com.digiwin.apollo.group.exceptions.ApolloConfigException;
import com.digiwin.apollo.group.spring.config.ConfigPropertySourceFactory;
import com.digiwin.apollo.group.spring.property.PlaceholderHelper;
import com.digiwin.apollo.group.spring.property.SpringValueRegistry;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;

public class SpringInjector {
    private static volatile Injector s_injector;
    private static final Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Injector getInjector() {
        if (s_injector == null) {
            Object object = lock;
            synchronized (object) {
                if (s_injector == null) {
                    try {
                        s_injector = Guice.createInjector((Module[])new Module[]{new SpringModule()});
                    }
                    catch (Throwable ex) {
                        ApolloConfigException exception = new ApolloConfigException("Unable to initialize Apollo Spring Injector!", ex);
                        Tracer.logError(exception);
                        throw exception;
                    }
                }
            }
        }
        return s_injector;
    }

    public static <T> T getInstance(Class<T> clazz) {
        try {
            return (T)SpringInjector.getInjector().getInstance(clazz);
        }
        catch (Throwable ex) {
            Tracer.logError(ex);
            throw new ApolloConfigException(String.format("Unable to load instance for %s!", clazz.getName()), ex);
        }
    }

    static {
        lock = new Object();
    }

    private static class SpringModule
    extends AbstractModule {
        private SpringModule() {
        }

        protected void configure() {
            this.bind(PlaceholderHelper.class).in(Singleton.class);
            this.bind(ConfigPropertySourceFactory.class).in(Singleton.class);
            this.bind(SpringValueRegistry.class).in(Singleton.class);
        }
    }
}

