/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.application.internals;

import com.digiwin.apollo.application.ConfigFileChangeListener;
import com.digiwin.apollo.application.PropertiesCompatibleConfigFile;
import com.digiwin.apollo.application.enums.ConfigSourceType;
import com.digiwin.apollo.application.internals.AbstractConfigRepository;
import com.digiwin.apollo.application.internals.ConfigRepository;
import com.digiwin.apollo.application.model.ConfigFileChangeEvent;
import com.google.common.base.Preconditions;
import java.util.Properties;

public class PropertiesCompatibleFileConfigRepository
extends AbstractConfigRepository
implements ConfigFileChangeListener {
    private final PropertiesCompatibleConfigFile configFile;
    private volatile Properties cachedProperties;

    public PropertiesCompatibleFileConfigRepository(PropertiesCompatibleConfigFile configFile) {
        this.configFile = configFile;
        this.configFile.addChangeListener(this);
        this.trySync();
    }

    @Override
    protected synchronized void sync() {
        Properties current = this.configFile.asProperties();
        Preconditions.checkState((current != null ? 1 : 0) != 0, (Object)"PropertiesCompatibleConfigFile.asProperties should never return null");
        if (this.cachedProperties != current) {
            this.cachedProperties = current;
            this.fireRepositoryChange(this.configFile.getNamespace(), this.cachedProperties);
        }
    }

    @Override
    public Properties getConfig() {
        if (this.cachedProperties == null) {
            this.sync();
        }
        return this.cachedProperties;
    }

    @Override
    public void setUpstreamRepository(ConfigRepository upstreamConfigRepository) {
    }

    @Override
    public ConfigSourceType getSourceType() {
        return this.configFile.getSourceType();
    }

    @Override
    public void onChange(ConfigFileChangeEvent changeEvent) {
        this.trySync();
    }
}

