/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.platform.util.http;

import com.digiwin.apollo.platform.build.ApolloInjector;
import com.digiwin.apollo.platform.exceptions.ApolloConfigException;
import com.digiwin.apollo.platform.exceptions.ApolloConfigStatusCodeException;
import com.digiwin.apollo.platform.util.ConfigUtil;
import com.digiwin.apollo.platform.util.http.HttpRequest;
import com.digiwin.apollo.platform.util.http.HttpResponse;
import com.google.common.base.Function;
import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class HttpUtil {
    private ConfigUtil m_configUtil = ApolloInjector.getInstance(ConfigUtil.class);
    private static final Gson GSON = new Gson();

    public <T> HttpResponse<T> doGet(HttpRequest httpRequest, final Class<T> responseType) {
        Function convertResponse = new Function<String, T>(){

            public T apply(String input) {
                return GSON.fromJson(input, responseType);
            }
        };
        return this.doGetWithSerializeFunction(httpRequest, convertResponse);
    }

    public <T> HttpResponse<T> doGet(HttpRequest httpRequest, final Type responseType) {
        Function convertResponse = new Function<String, T>(){

            public T apply(String input) {
                return GSON.fromJson(input, responseType);
            }
        };
        return this.doGetWithSerializeFunction(httpRequest, convertResponse);
    }

    private <T> HttpResponse<T> doGetWithSerializeFunction(HttpRequest httpRequest, Function<String, T> serializeFunction) {
        int statusCode;
        block36: {
            HttpResponse<Object> httpResponse;
            InputStreamReader isr = null;
            InputStreamReader esr = null;
            try {
                String response;
                int readTimeout;
                int connectTimeout;
                HttpURLConnection conn = (HttpURLConnection)new URL(httpRequest.getUrl()).openConnection();
                conn.setRequestMethod("GET");
                Map<String, String> headers = httpRequest.getHeaders();
                if (headers != null && headers.size() > 0) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        conn.setRequestProperty(entry.getKey(), entry.getValue());
                    }
                }
                if ((connectTimeout = httpRequest.getConnectTimeout()) < 0) {
                    connectTimeout = this.m_configUtil.getConnectTimeout();
                }
                if ((readTimeout = httpRequest.getReadTimeout()) < 0) {
                    readTimeout = this.m_configUtil.getReadTimeout();
                }
                conn.setConnectTimeout(connectTimeout);
                conn.setReadTimeout(readTimeout);
                conn.connect();
                statusCode = conn.getResponseCode();
                try {
                    isr = new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8);
                    response = CharStreams.toString((Readable)isr);
                }
                catch (IOException ex) {
                    InputStream errorStream = conn.getErrorStream();
                    if (errorStream != null) {
                        esr = new InputStreamReader(errorStream, StandardCharsets.UTF_8);
                        try {
                            CharStreams.toString((Readable)esr);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (statusCode == 200 || statusCode == 304) {
                        throw ex;
                    }
                    throw new ApolloConfigStatusCodeException(statusCode, (Throwable)ex);
                }
                if (statusCode == 200) {
                    HttpResponse<Object> httpResponse2 = new HttpResponse<Object>(statusCode, serializeFunction.apply((Object)response));
                    return httpResponse2;
                }
                if (statusCode != 304) break block36;
                httpResponse = new HttpResponse<Object>(statusCode, null);
            }
            catch (ApolloConfigStatusCodeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new ApolloConfigException("Could not complete get operation", ex);
            }
            finally {
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (IOException iOException) {}
                }
                if (esr != null) {
                    try {
                        esr.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return httpResponse;
        }
        throw new ApolloConfigStatusCodeException(statusCode, String.format("Get operation failed for %s", httpRequest.getUrl()));
    }
}

