/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.util.yaml;

import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.util.factory.PropertiesFactory;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.parser.ParserException;

public class YamlParser {
    private static final Log logger = LogFactory.getLog(YamlParser.class);
    private PropertiesFactory propertiesFactory = ApolloInjector.getInstance(PropertiesFactory.class);

    public Properties yamlToProperties(String yamlContent) {
        Yaml yaml = this.createYaml();
        final Properties result = this.propertiesFactory.getPropertiesInstance();
        this.process(new MatchCallback(){

            @Override
            public void process(Properties properties, Map<String, Object> map) {
                result.putAll((Map<?, ?>)properties);
            }
        }, yaml, yamlContent);
        return result;
    }

    private Yaml createYaml() {
        return new Yaml((BaseConstructor)new StrictMapAppenderConstructor());
    }

    private boolean process(MatchCallback callback, Yaml yaml, String content) {
        int count = 0;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Loading from YAML: " + content));
        }
        for (Object object : yaml.loadAll(content)) {
            if (object == null || !this.process(this.asMap(object), callback)) continue;
            ++count;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Loaded " + count + " document" + (count > 1 ? "s" : "") + " from YAML resource: " + content));
        }
        return count > 0;
    }

    private Map<String, Object> asMap(Object object) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (!(object instanceof Map)) {
            result.put("document", object);
            return result;
        }
        Map map = (Map)object;
        for (Map.Entry entry : map.entrySet()) {
            Object key;
            Object value = entry.getValue();
            if (value instanceof Map) {
                value = this.asMap(value);
            }
            if ((key = entry.getKey()) instanceof CharSequence) {
                result.put(key.toString(), value);
                continue;
            }
            result.put("[" + key.toString() + "]", value);
        }
        return result;
    }

    private boolean process(Map<String, Object> map, MatchCallback callback) {
        Properties properties = this.propertiesFactory.getPropertiesInstance();
        properties.putAll(this.getFlattenedMap(map));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Merging document (no matchers set): " + map));
        }
        callback.process(properties, map);
        return true;
    }

    private Map<String, Object> getFlattenedMap(Map<String, Object> source) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.buildFlattenedMap(result, source, null);
        return result;
    }

    private void buildFlattenedMap(Map<String, Object> result, Map<String, Object> source, String path) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (!StringUtils.isBlank(path)) {
                key = key.startsWith("[") ? path + key : path + '.' + key;
            }
            if ((value = entry.getValue()) instanceof String) {
                result.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                this.buildFlattenedMap(result, map, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                int count = 0;
                for (Object object : collection) {
                    this.buildFlattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), key);
                }
                continue;
            }
            result.put(key, value != null ? value.toString() : "");
        }
    }

    private static class StrictMapAppenderConstructor
    extends SafeConstructor {
        StrictMapAppenderConstructor() {
            super(new LoaderOptions());
        }

        protected Map<Object, Object> constructMapping(MappingNode node) {
            try {
                return super.constructMapping(node);
            }
            catch (IllegalStateException ex) {
                throw new ParserException("while parsing MappingNode", node.getStartMark(), ex.getMessage(), node.getEndMark());
            }
        }

        protected Map<Object, Object> createDefaultMap(int initSize) {
            final Map delegate = super.createDefaultMap(initSize);
            return new AbstractMap<Object, Object>(){

                @Override
                public Object put(Object key, Object value) {
                    if (delegate.containsKey(key)) {
                        throw new IllegalStateException("Duplicate key: " + key);
                    }
                    return delegate.put(key, value);
                }

                @Override
                public Set<Map.Entry<Object, Object>> entrySet() {
                    return delegate.entrySet();
                }
            };
        }
    }

    private static interface MatchCallback {
        public void process(Properties var1, Map<String, Object> var2);
    }
}

