/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.application.spring.property;

import com.digiwin.apollo.application.ConfigChangeListener;
import com.digiwin.apollo.application.model.ConfigChangeEvent;
import com.digiwin.apollo.application.spring.property.PlaceholderHelper;
import com.digiwin.apollo.application.spring.property.SpringValue;
import com.digiwin.apollo.application.spring.property.SpringValueRegistry;
import com.digiwin.apollo.application.spring.util.SpringInjector;
import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class AutoUpdateConfigChangeListener
implements ConfigChangeListener {
    private static final Log logger = LogFactory.getLog(AutoUpdateConfigChangeListener.class);
    private final boolean typeConverterHasConvertIfNecessaryWithFieldParameter = this.testTypeConverterHasConvertIfNecessaryWithFieldParameter();
    private final Environment environment;
    private final ConfigurableBeanFactory beanFactory;
    private final TypeConverter typeConverter;
    private final PlaceholderHelper placeholderHelper;
    private final SpringValueRegistry springValueRegistry;
    private final Gson gson;

    public AutoUpdateConfigChangeListener(Environment environment, ConfigurableListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.typeConverter = this.beanFactory.getTypeConverter();
        this.environment = environment;
        this.placeholderHelper = SpringInjector.getInstance(PlaceholderHelper.class);
        this.springValueRegistry = SpringInjector.getInstance(SpringValueRegistry.class);
        this.gson = new Gson();
    }

    @Override
    public void onChange(ConfigChangeEvent changeEvent) {
        Set<String> keys = changeEvent.changedKeys();
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        for (String key : keys) {
            Collection<SpringValue> targetValues = this.springValueRegistry.get((BeanFactory)this.beanFactory, key);
            if (targetValues == null || targetValues.isEmpty()) continue;
            for (SpringValue val : targetValues) {
                this.updateSpringValue(val);
            }
        }
    }

    private void updateSpringValue(SpringValue springValue) {
        try {
            Object value = this.resolvePropertyValue(springValue);
            springValue.update(value);
            logger.info((Object)("Auto update apollo changed value successfully, new value: " + String.valueOf(value) + ", " + String.valueOf(springValue)));
        }
        catch (Throwable ex) {
            logger.error((Object)("Auto update apollo changed value failed, " + springValue.toString()), ex);
        }
    }

    private Object resolvePropertyValue(SpringValue springValue) {
        Object value = this.placeholderHelper.resolvePropertyValue(this.beanFactory, springValue.getBeanName(), springValue.getPlaceholder());
        value = springValue.isJson() ? this.parseJsonValue((String)value, springValue.getGenericType()) : (springValue.isField() ? (this.typeConverterHasConvertIfNecessaryWithFieldParameter ? this.typeConverter.convertIfNecessary(value, springValue.getTargetType(), springValue.getField()) : this.typeConverter.convertIfNecessary(value, springValue.getTargetType())) : this.typeConverter.convertIfNecessary(value, springValue.getTargetType(), springValue.getMethodParameter()));
        return value;
    }

    private Object parseJsonValue(String json, Type targetType) {
        try {
            return this.gson.fromJson(json, targetType);
        }
        catch (Throwable ex) {
            logger.error((Object)("Parsing json '" + json + "' to type " + String.valueOf(targetType) + " failed!"), ex);
            throw ex;
        }
    }

    private boolean testTypeConverterHasConvertIfNecessaryWithFieldParameter() {
        try {
            TypeConverter.class.getMethod("convertIfNecessary", Object.class, Class.class, Field.class);
        }
        catch (Throwable ex) {
            return false;
        }
        return true;
    }
}

