/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.foundation.internals.provider;

import com.ctrip.framework.foundation.internals.Utils;
import com.ctrip.framework.foundation.internals.io.BOMInputStream;
import com.ctrip.framework.foundation.spi.provider.ApplicationProvider;
import com.ctrip.framework.foundation.spi.provider.Provider;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultApplicationProvider
implements ApplicationProvider {
    private static final Log logger = LogFactory.getLog(DefaultApplicationProvider.class);
    public static final String APP_PROPERTIES_CLASSPATH = "/META-INF/app.properties";
    private Properties m_appProperties = new Properties();
    private String m_appId;
    private String accessKeySecret;

    @Override
    public void initialize() {
        try {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(APP_PROPERTIES_CLASSPATH.substring(1));
            if (in == null) {
                in = DefaultApplicationProvider.class.getResourceAsStream(APP_PROPERTIES_CLASSPATH);
            }
            this.initialize(in);
        }
        catch (Throwable ex) {
            logger.error((Object)"Initialize DefaultApplicationProvider failed.", ex);
        }
    }

    @Override
    public void initialize(InputStream in) {
        try {
            if (in != null) {
                try {
                    this.m_appProperties.load(new InputStreamReader((InputStream)new BOMInputStream(in), StandardCharsets.UTF_8));
                }
                finally {
                    in.close();
                }
            }
            this.initAppId();
            this.initAccessKey();
        }
        catch (Throwable ex) {
            logger.error((Object)"Initialize DefaultApplicationProvider failed.", ex);
        }
    }

    @Override
    public String getAppId() {
        return this.m_appId;
    }

    @Override
    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    @Override
    public boolean isAppIdSet() {
        return !Utils.isBlank(this.m_appId);
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        if ("app.id".equals(name)) {
            String val = this.getAppId();
            return val == null ? defaultValue : val;
        }
        if ("apollo.accesskey.secret".equals(name)) {
            String val = this.getAccessKeySecret();
            return val == null ? defaultValue : val;
        }
        String val = this.m_appProperties.getProperty(name, defaultValue);
        return val == null ? defaultValue : val;
    }

    @Override
    public Class<? extends Provider> getType() {
        return ApplicationProvider.class;
    }

    private void initAppId() {
        this.m_appId = System.getProperty("app.id");
        if (!Utils.isBlank(this.m_appId)) {
            this.m_appId = this.m_appId.trim();
            logger.info((Object)("App ID is set to " + this.m_appId + " by app.id property from System Property"));
            return;
        }
        this.m_appId = System.getenv("APP_ID");
        if (!Utils.isBlank(this.m_appId)) {
            this.m_appId = this.m_appId.trim();
            logger.info((Object)("App ID is set to " + this.m_appId + " by APP_ID property from OS environment variable"));
            return;
        }
        this.m_appId = this.m_appProperties.getProperty("app.id");
        if (!Utils.isBlank(this.m_appId)) {
            this.m_appId = this.m_appId.trim();
            logger.info((Object)("App ID is set to " + this.m_appId + " by app.id property from /META-INF/app.properties"));
            return;
        }
        this.m_appId = null;
        logger.warn((Object)"app.id is not available from System Property and /META-INF/app.properties. It is set to null");
    }

    private void initAccessKey() {
        this.accessKeySecret = System.getProperty("apollo.accesskey.secret");
        if (!Utils.isBlank(this.accessKeySecret)) {
            this.accessKeySecret = this.accessKeySecret.trim();
            logger.info((Object)"ACCESSKEY SECRET is set by apollo.accesskey.secret property from System Property");
            return;
        }
        this.accessKeySecret = System.getenv("APOLLO_ACCESSKEY_SECRET");
        if (!Utils.isBlank(this.accessKeySecret)) {
            this.accessKeySecret = this.accessKeySecret.trim();
            logger.info((Object)"ACCESSKEY SECRET is set by APOLLO_ACCESSKEY_SECRET property from OS environment variable");
            return;
        }
        this.accessKeySecret = this.m_appProperties.getProperty("apollo.accesskey.secret");
        if (!Utils.isBlank(this.accessKeySecret)) {
            this.accessKeySecret = this.accessKeySecret.trim();
            logger.info((Object)"ACCESSKEY SECRET is set by apollo.accesskey.secret property from /META-INF/app.properties");
            return;
        }
        this.accessKeySecret = null;
    }

    public String toString() {
        return "appId [" + this.getAppId() + "] properties: " + String.valueOf(this.m_appProperties) + " (DefaultApplicationProvider)";
    }
}

