/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.internals;

import com.ctrip.framework.apollo.core.utils.ClassLoaderUtil;
import com.ctrip.framework.apollo.enums.ConfigSourceType;
import com.ctrip.framework.apollo.enums.PropertyChangeType;
import com.ctrip.framework.apollo.internals.AbstractConfig;
import com.ctrip.framework.apollo.internals.ConfigRepository;
import com.ctrip.framework.apollo.internals.RepositoryChangeListener;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.util.ExceptionUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultConfig
extends AbstractConfig
implements RepositoryChangeListener {
    private static final Log logger = LogFactory.getLog(DefaultConfig.class);
    private final String m_namespace;
    private final Properties m_resourceProperties;
    private final AtomicReference<Properties> m_configProperties;
    private final ConfigRepository m_configRepository;
    private final RateLimiter m_warnLogRateLimiter;
    private volatile ConfigSourceType m_sourceType = ConfigSourceType.NONE;

    public DefaultConfig(String namespace, ConfigRepository configRepository) {
        this.m_namespace = namespace;
        this.m_resourceProperties = this.loadFromResource(this.m_namespace);
        this.m_configRepository = configRepository;
        this.m_configProperties = new AtomicReference();
        this.m_warnLogRateLimiter = RateLimiter.create((double)0.017);
        this.initialize();
    }

    private void initialize() {
        try {
            this.updateConfig(this.m_configRepository.getConfig(), this.m_configRepository.getSourceType());
        }
        catch (Throwable ex) {
            Tracer.logError(ex);
            logger.warn((Object)("Init Apollo Local Config failed - namespace: " + this.m_namespace + ", reason: " + ExceptionUtil.getDetailMessage(ex) + "."));
        }
        finally {
            this.m_configRepository.addChangeListener(this);
        }
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value == null && this.m_configProperties.get() != null) {
            value = this.m_configProperties.get().getProperty(key);
        }
        if (value == null) {
            value = System.getenv(key);
        }
        if (value == null && this.m_resourceProperties != null) {
            value = this.m_resourceProperties.getProperty(key);
        }
        if (value == null && this.m_configProperties.get() == null && this.m_warnLogRateLimiter.tryAcquire()) {
            logger.warn((Object)("Could not load config for namespace " + this.m_namespace + " from Apollo, please check whether the configs are released in Apollo! Return default value now!"));
        }
        return value == null ? defaultValue : value;
    }

    @Override
    public Set<String> getPropertyNames() {
        Properties properties = this.m_configProperties.get();
        if (properties == null) {
            return Collections.emptySet();
        }
        return this.stringPropertyNames(properties);
    }

    @Override
    public ConfigSourceType getSourceType() {
        return this.m_sourceType;
    }

    private Set<String> stringPropertyNames(Properties properties) {
        LinkedHashMap<String, String> h = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            Object k = e.getKey();
            Object v = e.getValue();
            if (!(k instanceof String) || !(v instanceof String)) continue;
            h.put((String)k, (String)v);
        }
        return h.keySet();
    }

    @Override
    public synchronized void onRepositoryChange(String namespace, Properties newProperties) {
        if (newProperties.equals(this.m_configProperties.get())) {
            return;
        }
        ConfigSourceType sourceType = this.m_configRepository.getSourceType();
        Properties newConfigProperties = this.propertiesFactory.getPropertiesInstance();
        newConfigProperties.putAll((Map<?, ?>)newProperties);
        Map<String, ConfigChange> actualChanges = this.updateAndCalcConfigChanges(newConfigProperties, sourceType);
        if (actualChanges.isEmpty()) {
            return;
        }
        this.fireConfigChange(new ConfigChangeEvent(this.m_namespace, actualChanges));
        Tracer.logEvent("Apollo.Client.ConfigChanges", this.m_namespace);
    }

    private void updateConfig(Properties newConfigProperties, ConfigSourceType sourceType) {
        this.m_configProperties.set(newConfigProperties);
        this.m_sourceType = sourceType;
    }

    private Map<String, ConfigChange> updateAndCalcConfigChanges(Properties newConfigProperties, ConfigSourceType sourceType) {
        List<ConfigChange> configChanges = this.calcPropertyChanges(this.m_namespace, this.m_configProperties.get(), newConfigProperties);
        ImmutableMap.Builder actualChanges = new ImmutableMap.Builder();
        for (ConfigChange change : configChanges) {
            change.setOldValue(this.getProperty(change.getPropertyName(), change.getOldValue()));
        }
        this.updateConfig(newConfigProperties, sourceType);
        this.clearConfigCache();
        for (ConfigChange change : configChanges) {
            change.setNewValue(this.getProperty(change.getPropertyName(), change.getNewValue()));
            switch (change.getChangeType()) {
                case ADDED: {
                    if (Objects.equals(change.getOldValue(), change.getNewValue())) break;
                    if (change.getOldValue() != null) {
                        change.setChangeType(PropertyChangeType.MODIFIED);
                    }
                    actualChanges.put((Object)change.getPropertyName(), (Object)change);
                    break;
                }
                case MODIFIED: {
                    if (Objects.equals(change.getOldValue(), change.getNewValue())) break;
                    actualChanges.put((Object)change.getPropertyName(), (Object)change);
                    break;
                }
                case DELETED: {
                    if (Objects.equals(change.getOldValue(), change.getNewValue())) break;
                    if (change.getNewValue() != null) {
                        change.setChangeType(PropertyChangeType.MODIFIED);
                    }
                    actualChanges.put((Object)change.getPropertyName(), (Object)change);
                    break;
                }
            }
        }
        return actualChanges.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadFromResource(String namespace) {
        String name = String.format("META-INF/config/%s.properties", namespace);
        InputStream in = ClassLoaderUtil.getLoader().getResourceAsStream(name);
        Properties properties = null;
        if (in != null) {
            properties = this.propertiesFactory.getPropertiesInstance();
            try {
                properties.load(in);
            }
            catch (IOException ex) {
                Tracer.logError(ex);
                logger.error((Object)("Load resource config for namespace " + namespace + " failed"), (Throwable)ex);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }
}

