/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.group.internals;

import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.digiwin.apollo.group.PropertiesCompatibleConfigFile;
import com.digiwin.apollo.group.build.ApolloInjector;
import com.digiwin.apollo.group.exceptions.ApolloConfigException;
import com.digiwin.apollo.group.internals.ConfigRepository;
import com.digiwin.apollo.group.internals.PlainTextConfigFile;
import com.digiwin.apollo.group.util.ExceptionUtil;
import com.digiwin.apollo.group.util.yaml.YamlParser;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class YamlConfigFile
extends PlainTextConfigFile
implements PropertiesCompatibleConfigFile {
    private static final Log logger = LogFactory.getLog(YamlConfigFile.class);
    private volatile Properties cachedProperties;

    public YamlConfigFile(String namespace, ConfigRepository configRepository) {
        super(namespace, configRepository);
        this.tryTransformToProperties();
    }

    @Override
    public ConfigFileFormat getConfigFileFormat() {
        return ConfigFileFormat.YAML;
    }

    @Override
    protected void update(Properties newProperties) {
        super.update(newProperties);
        this.tryTransformToProperties();
    }

    @Override
    public Properties asProperties() {
        if (this.cachedProperties == null) {
            this.transformToProperties();
        }
        return this.cachedProperties;
    }

    private boolean tryTransformToProperties() {
        try {
            this.transformToProperties();
            return true;
        }
        catch (Throwable ex) {
            Tracer.logEvent("ApolloConfigException", ExceptionUtil.getDetailMessage(ex));
            logger.warn((Object)("yaml to properties failed, reason: " + ExceptionUtil.getDetailMessage(ex)));
            return false;
        }
    }

    private synchronized void transformToProperties() {
        this.cachedProperties = this.toProperties();
    }

    private Properties toProperties() {
        if (!this.hasContent()) {
            return this.propertiesFactory.getPropertiesInstance();
        }
        try {
            return ApolloInjector.getInstance(YamlParser.class).yamlToProperties(this.getContent());
        }
        catch (Throwable ex) {
            ApolloConfigException exception = new ApolloConfigException("Parse yaml file content failed for namespace: " + this.m_namespace, ex);
            Tracer.logError(exception);
            throw exception;
        }
    }
}

