/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.application.internals;

import com.ctrip.framework.apollo.tracer.Tracer;
import com.digiwin.apollo.application.enums.ConfigSourceType;
import com.digiwin.apollo.application.internals.AbstractConfig;
import com.digiwin.apollo.application.internals.ConfigRepository;
import com.digiwin.apollo.application.internals.RepositoryChangeListener;
import com.digiwin.apollo.application.model.ApplicationConfigChange;
import com.digiwin.apollo.application.model.ConfigChangeEvent;
import com.digiwin.apollo.application.util.ExceptionUtil;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleConfig
extends AbstractConfig
implements RepositoryChangeListener {
    private static final Log logger = LogFactory.getLog(SimpleConfig.class);
    private final String m_namespace;
    private final ConfigRepository m_configRepository;
    private volatile Properties m_configProperties;
    private volatile ConfigSourceType m_sourceType = ConfigSourceType.NONE;

    public SimpleConfig(String namespace, ConfigRepository configRepository) {
        this.m_namespace = namespace;
        this.m_configRepository = configRepository;
        this.initialize();
    }

    private void initialize() {
        try {
            this.updateConfig(this.m_configRepository.getConfig(), this.m_configRepository.getSourceType());
        }
        catch (Throwable ex) {
            Tracer.logError(ex);
            logger.warn((Object)("Init Apollo Simple Config failed - namespace: " + this.m_namespace + ", reason: " + ExceptionUtil.getDetailMessage(ex)));
        }
        finally {
            this.m_configRepository.addChangeListener(this);
        }
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        if (this.m_configProperties == null) {
            logger.warn((Object)"Could not load config from Apollo, always return default value!");
            return defaultValue;
        }
        return this.m_configProperties.getProperty(key, defaultValue);
    }

    @Override
    public Set<String> getPropertyNames() {
        if (this.m_configProperties == null) {
            return Collections.emptySet();
        }
        return this.m_configProperties.stringPropertyNames();
    }

    @Override
    public ConfigSourceType getSourceType() {
        return this.m_sourceType;
    }

    @Override
    public synchronized void onRepositoryChange(String namespace, Properties newProperties) {
        if (newProperties.equals(this.m_configProperties)) {
            return;
        }
        Properties newConfigProperties = this.propertiesFactory.getPropertiesInstance();
        newConfigProperties.putAll((Map<?, ?>)newProperties);
        List<ApplicationConfigChange> changes = this.calcPropertyChanges(namespace, this.m_configProperties, newConfigProperties);
        ImmutableMap changeMap = Maps.uniqueIndex(changes, (Function)new Function<ApplicationConfigChange, String>(this){

            public String apply(ApplicationConfigChange input) {
                return input.getPropertyName();
            }
        });
        this.updateConfig(newConfigProperties, this.m_configRepository.getSourceType());
        this.clearConfigCache();
        this.fireConfigChange(new ConfigChangeEvent(this.m_namespace, (Map<String, ApplicationConfigChange>)changeMap));
        Tracer.logEvent("Apollo.Client.ConfigChanges", this.m_namespace);
    }

    private void updateConfig(Properties newConfigProperties, ConfigSourceType sourceType) {
        this.m_configProperties = newConfigProperties;
        this.m_sourceType = sourceType;
    }
}

