/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.application.util;

import com.ctrip.framework.apollo.core.MetaDomainConsts;
import com.ctrip.framework.apollo.core.enums.Env;
import com.ctrip.framework.apollo.core.enums.EnvUtils;
import com.ctrip.framework.foundation.Foundation;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.RateLimiter;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigUtil {
    private static final Log logger = LogFactory.getLog(ConfigUtil.class);
    private int refreshInterval = 5;
    private TimeUnit refreshIntervalTimeUnit = TimeUnit.MINUTES;
    private int connectTimeout = 1000;
    private int readTimeout = 5000;
    private String cluster;
    private int loadConfigQPS = 2;
    private int longPollQPS = 2;
    private long onErrorRetryInterval = 1L;
    private TimeUnit onErrorRetryIntervalTimeUnit = TimeUnit.SECONDS;
    private long maxConfigCacheSize = 500L;
    private long configCacheExpireTime = 1L;
    private TimeUnit configCacheExpireTimeUnit = TimeUnit.MINUTES;
    private long longPollingInitialDelayInMills = 2000L;
    private boolean autoUpdateInjectedSpringProperties = true;
    private final RateLimiter warnLogRateLimiter = RateLimiter.create((double)0.017);
    private boolean propertiesOrdered = false;

    public ConfigUtil() {
        this.initRefreshInterval();
        this.initConnectTimeout();
        this.initReadTimeout();
        this.initCluster();
        this.initQPS();
        this.initMaxConfigCacheSize();
        this.initLongPollingInitialDelayInMills();
        this.initAutoUpdateInjectedSpringProperties();
        this.initPropertiesOrdered();
    }

    public String getAppId() {
        String appId = Foundation.app().getAppId();
        if (Strings.isNullOrEmpty((String)appId)) {
            appId = "ApolloNoAppIdPlaceHolder";
            if (this.warnLogRateLimiter.tryAcquire()) {
                logger.debug((Object)"app.id is not set, please make sure it is set in classpath:/META-INF/app.properties, now apollo will only load public namespace configurations!");
            }
        }
        return appId;
    }

    public String getAccessKeySecret() {
        return Foundation.app().getAccessKeySecret();
    }

    public String getDataCenter() {
        return Foundation.server().getDataCenter();
    }

    private void initCluster() {
        this.cluster = System.getProperty("apollo.cluster");
        if (Strings.isNullOrEmpty((String)this.cluster)) {
            this.cluster = this.getDataCenter();
        }
        if (Strings.isNullOrEmpty((String)this.cluster)) {
            this.cluster = "default";
        }
    }

    public String getCluster() {
        String cluster = System.getProperty("application.version");
        return cluster;
    }

    public Env getApolloEnv() {
        return EnvUtils.transformEnv(Foundation.server().getEnvType());
    }

    public String getLocalIp() {
        return Foundation.net().getHostAddress();
    }

    public String getMetaServerDomainName() {
        return MetaDomainConsts.getDomain(this.getApolloEnv());
    }

    private void initConnectTimeout() {
        String customizedConnectTimeout = System.getProperty("apollo.connectTimeout");
        if (!Strings.isNullOrEmpty((String)customizedConnectTimeout)) {
            try {
                this.connectTimeout = Integer.parseInt(customizedConnectTimeout);
            }
            catch (Throwable ex) {
                logger.error((Object)("Config for apollo.connectTimeout is invalid: " + customizedConnectTimeout));
            }
        }
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    private void initReadTimeout() {
        String customizedReadTimeout = System.getProperty("apollo.readTimeout");
        if (!Strings.isNullOrEmpty((String)customizedReadTimeout)) {
            try {
                this.readTimeout = Integer.parseInt(customizedReadTimeout);
            }
            catch (Throwable ex) {
                logger.error((Object)("Config for apollo.readTimeout is invalid: " + customizedReadTimeout));
            }
        }
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    private void initRefreshInterval() {
        String customizedRefreshInterval = System.getProperty("apollo.refreshInterval");
        if (!Strings.isNullOrEmpty((String)customizedRefreshInterval)) {
            try {
                this.refreshInterval = Integer.parseInt(customizedRefreshInterval);
            }
            catch (Throwable ex) {
                logger.error((Object)("Config for apollo.refreshInterval is invalid: " + customizedRefreshInterval));
            }
        }
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public TimeUnit getRefreshIntervalTimeUnit() {
        return this.refreshIntervalTimeUnit;
    }

    private void initQPS() {
        String customizedLongPollQPS;
        String customizedLoadConfigQPS = System.getProperty("apollo.loadConfigQPS");
        if (!Strings.isNullOrEmpty((String)customizedLoadConfigQPS)) {
            try {
                this.loadConfigQPS = Integer.parseInt(customizedLoadConfigQPS);
            }
            catch (Throwable ex) {
                logger.error((Object)("Config for apollo.loadConfigQPS is invalid: " + customizedLoadConfigQPS));
            }
        }
        if (!Strings.isNullOrEmpty((String)(customizedLongPollQPS = System.getProperty("apollo.longPollQPS")))) {
            try {
                this.longPollQPS = Integer.parseInt(customizedLongPollQPS);
            }
            catch (Throwable ex) {
                logger.error((Object)("Config for apollo.longPollQPS is invalid: " + customizedLongPollQPS));
            }
        }
    }

    public int getLoadConfigQPS() {
        return this.loadConfigQPS;
    }

    public int getLongPollQPS() {
        return this.longPollQPS;
    }

    public long getOnErrorRetryInterval() {
        return this.onErrorRetryInterval;
    }

    public TimeUnit getOnErrorRetryIntervalTimeUnit() {
        return this.onErrorRetryIntervalTimeUnit;
    }

    public String getDefaultLocalCacheDir() {
        String cacheRoot = this.getCustomizedCacheRoot();
        if (!Strings.isNullOrEmpty((String)cacheRoot)) {
            return cacheRoot + File.separator + this.getAppId();
        }
        cacheRoot = this.isOSWindows() ? "C:\\opt\\data\\%s" : "/opt/data/%s";
        return String.format(cacheRoot, this.getAppId());
    }

    private String getCustomizedCacheRoot() {
        String cacheRoot = System.getProperty("apollo.cacheDir");
        if (Strings.isNullOrEmpty((String)cacheRoot)) {
            cacheRoot = System.getenv("APOLLO_CACHEDIR");
        }
        if (Strings.isNullOrEmpty((String)cacheRoot)) {
            cacheRoot = Foundation.server().getProperty("apollo.cacheDir", null);
        }
        if (Strings.isNullOrEmpty((String)cacheRoot)) {
            cacheRoot = Foundation.app().getProperty("apollo.cacheDir", null);
        }
        return cacheRoot;
    }

    public boolean isInLocalMode() {
        try {
            return Env.LOCAL == this.getApolloEnv();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean isOSWindows() {
        String osName = System.getProperty("os.name");
        if (Strings.isNullOrEmpty((String)osName)) {
            return false;
        }
        return osName.startsWith("Windows");
    }

    private void initMaxConfigCacheSize() {
        String customizedConfigCacheSize = System.getProperty("apollo.configCacheSize");
        if (!Strings.isNullOrEmpty((String)customizedConfigCacheSize)) {
            try {
                this.maxConfigCacheSize = Long.parseLong(customizedConfigCacheSize);
            }
            catch (Throwable ex) {
                logger.error((Object)("Config for apollo.configCacheSize is invalid: " + customizedConfigCacheSize));
            }
        }
    }

    public long getMaxConfigCacheSize() {
        return this.maxConfigCacheSize;
    }

    public long getConfigCacheExpireTime() {
        return this.configCacheExpireTime;
    }

    public TimeUnit getConfigCacheExpireTimeUnit() {
        return this.configCacheExpireTimeUnit;
    }

    private void initLongPollingInitialDelayInMills() {
        String customizedLongPollingInitialDelay = System.getProperty("apollo.longPollingInitialDelayInMills");
        if (!Strings.isNullOrEmpty((String)customizedLongPollingInitialDelay)) {
            try {
                this.longPollingInitialDelayInMills = Long.parseLong(customizedLongPollingInitialDelay);
            }
            catch (Throwable ex) {
                logger.error((Object)("Config for apollo.longPollingInitialDelayInMills is invalid: " + customizedLongPollingInitialDelay));
            }
        }
    }

    public long getLongPollingInitialDelayInMills() {
        return this.longPollingInitialDelayInMills;
    }

    private void initAutoUpdateInjectedSpringProperties() {
        String enableAutoUpdate = System.getProperty("apollo.autoUpdateInjectedSpringProperties");
        if (Strings.isNullOrEmpty((String)enableAutoUpdate)) {
            enableAutoUpdate = Foundation.app().getProperty("apollo.autoUpdateInjectedSpringProperties", null);
        }
        if (!Strings.isNullOrEmpty((String)enableAutoUpdate)) {
            this.autoUpdateInjectedSpringProperties = Boolean.parseBoolean(enableAutoUpdate.trim());
        }
    }

    public boolean isAutoUpdateInjectedSpringPropertiesEnabled() {
        return this.autoUpdateInjectedSpringProperties;
    }

    private void initPropertiesOrdered() {
        String enablePropertiesOrdered = System.getProperty("apollo.property.order.enable");
        if (Strings.isNullOrEmpty((String)enablePropertiesOrdered)) {
            enablePropertiesOrdered = Foundation.app().getProperty("apollo.property.order.enable", "false");
        }
        if (!Strings.isNullOrEmpty((String)enablePropertiesOrdered)) {
            try {
                this.propertiesOrdered = Boolean.parseBoolean(enablePropertiesOrdered);
            }
            catch (Throwable ex) {
                logger.warn((Object)("Config for apollo.property.order.enable is invalid: " + enablePropertiesOrdered + ", set default value: false"));
            }
        }
    }

    public boolean isPropertiesOrderEnabled() {
        return this.propertiesOrdered;
    }
}

