#2022-02-11;

CREATE TABLE IF NOT EXISTS `undo_log`
(
    `branch_id`     BIGINT(20)   NOT NULL COMMENT 'branch transaction id',
    `xid`           VARCHAR(100) NOT NULL COMMENT 'global transaction id',
    `context`       VARCHAR(128) NOT NULL COMMENT 'undo_log context,such as serialization',
    `rollback_info` LONGBLOB     NOT NULL COMMENT 'rollback info',
    `log_status`    INT(11)      NOT NULL COMMENT '0:normal status,1:defense status',
    `log_created`   DATETIME(6)  NOT NULL COMMENT 'create datetime',
    `log_modified`  DATETIME(6)  NOT NULL COMMENT 'modify datetime',
    UNIQUE KEY `ux_undo_log` (`xid`, `branch_id`)
) ENGINE = InnoDB
  AUTO_INCREMENT = 1
  DEFAULT CHARSET = utf8 COMMENT ='AT transaction mode undo table';

#2022-03-17;

ALTER TABLE dw_schedule_time 
 CHANGE COLUMN byday byday VARCHAR(255) NULL DEFAULT NULL COMMENT '星期n' COLLATE 'utf8_bin', 
 CHANGE COLUMN byweeklyday byweeklyday VARCHAR(255) NULL DEFAULT NULL COMMENT '當月中的第n個星期m' COLLATE 'utf8_bin', 
 CHANGE COLUMN bymonthday bymonthday VARCHAR(255) NULL DEFAULT NULL COMMENT '當月中的第n天' COLLATE 'utf8_bin';

#2022-03-17;

UPDATE `dw_rdbms_fields` SET `FIELD_TYPE`='varchar' WHERE  `FIELD_NAME`='bymonthday' AND `TABLE_NAME`='dw_schedule_time';

#2022-03-17;

UPDATE `dw_rdbms_fields` SET `SIZE`='255' WHERE  `FIELD_NAME`='bymonthday' AND `TABLE_NAME`='dw_schedule_time';

#2022-03-17;

UPDATE `dw_rdbms_fields` SET `SIZE`='255' WHERE  `FIELD_NAME`='byweeklyday' AND `TABLE_NAME`='dw_schedule_time';

#2022-03-17;

UPDATE `dw_rdbms_fields` SET `SIZE`='255' WHERE  `FIELD_NAME`='byday' AND `TABLE_NAME`='dw_schedule_time'; 