/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.servicechain;

import com.digiwin.app.autoconfigure.condition.DWServiceChainEnableCondition;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.module.spring.DWModuleSpringUtils;
import com.digiwin.app.service.processor.DWInvokerBeanContainerBeanProcessor;
import com.digiwin.app.service.processor.DWInvokerBeanProcessor;
import com.digiwin.app.service.utils.DWServiceChainUtils;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={DWServiceChainEnableCondition.class})
public class DWServiceChainAutoConfiguration {
    public DWServiceChainAutoConfiguration() {
        DWModuleSpringUtils.registerModuleConfigurationClass(DWServiceChainAutoConfiguration.class);
    }

    @Bean(value={"DWInvokerBeanDefaultProcessor"})
    public static DWInvokerBeanContainerBeanProcessor getDWInvokerBeanDefaultProcessor(List<DWInvokerBeanProcessor> invokerBeanProcessorList) {
        String customId = DWApplicationConfigUtils.getProperty((String)"dwServiceChainCustomId", (String)"");
        if (!customId.isEmpty() && !customId.equals("@dwServiceChainCustomId@")) {
            DWServiceChainUtils.setIdentity((String)customId);
        } else {
            DWServiceChainUtils.setIdentity((String)DWApplicationConfigUtils.getProperty((String)"appId", (String)""));
        }
        DWInvokerBeanContainerBeanProcessor beanProcessor = new DWInvokerBeanContainerBeanProcessor();
        if (invokerBeanProcessorList != null) {
            invokerBeanProcessorList.forEach(ib -> beanProcessor.registerProcessor(ib));
        }
        return beanProcessor;
    }
}

