/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.DWAutoConfigureUtils;
import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWHeaderRepository;
import com.digiwin.app.container.DWHeaderRepositoryList;
import com.digiwin.app.container.DWServiceInvocationProcessor;
import com.digiwin.app.container.DWServiceRepository;
import com.digiwin.app.container.DWServiceRepositoryList;
import com.digiwin.app.service.DWServiceLookupProcessor;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

@Configuration
@ConditionalOnMissingBean(value={DWContainerContext.class})
@Import(value={DWContainerBeanProcessorsRegistrar.class})
public class DWContainerAutoConfiguration {

    public static class DWContainerBeanProcessorsRegistrar
    implements ImportBeanDefinitionRegistrar,
    BeanFactoryAware {
        private ConfigurableListableBeanFactory beanFactory;

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            if (beanFactory instanceof ConfigurableListableBeanFactory) {
                this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
            }
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            List<DWHeaderRepository> headerRepositories = DWAutoConfigureUtils.getOrderedBeansOfType(this.beanFactory, DWHeaderRepository.class);
            DWHeaderRepositoryList headerRepositoryList = new DWHeaderRepositoryList();
            headerRepositoryList.setRepositories(headerRepositories);
            List<DWServiceRepository> serviceRepositories = DWAutoConfigureUtils.getOrderedBeansOfType(this.beanFactory, DWServiceRepository.class);
            DWServiceRepositoryList serviceRepositoryList = new DWServiceRepositoryList();
            serviceRepositoryList.setRepositories(serviceRepositories);
            List<DWServiceInvocationProcessor> serviceInvocations = DWAutoConfigureUtils.getOrderedBeansOfType(this.beanFactory, DWServiceInvocationProcessor.class);
            DWServiceInvocationProcessor[] serviceInvocationArrays = new DWServiceInvocationProcessor[serviceInvocations.size()];
            serviceInvocations.toArray(serviceInvocationArrays);
            DWServiceLookupProcessor lookupProcessor = (DWServiceLookupProcessor)this.beanFactory.getBean(DWServiceLookupProcessor.class);
            DWContainerContext containerContext = new DWContainerContext((DWHeaderRepository)headerRepositoryList, (DWServiceRepository)serviceRepositoryList, serviceInvocationArrays, lookupProcessor);
            this.beanFactory.registerSingleton("DWHeaderRepository", (Object)headerRepositoryList);
            this.beanFactory.registerSingleton("DWServiceRepository", (Object)serviceRepositoryList);
            this.beanFactory.registerSingleton("DWContainerContext", (Object)containerContext);
            containerContext.refresh();
        }
    }
}

