/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.redis.service.DWRedisService;
import com.digiwin.app.redis.service.DefaultRedisService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
public class DWRedisAutoConfiguration {
    @Bean
    public DWRedisService redisService(RedisTemplate<String, Object> redisTemplate) {
        DefaultRedisService redisService = new DefaultRedisService();
        redisService.setOperator(redisTemplate);
        return redisService;
    }

    @Bean
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redis = new RedisTemplate();
        redis.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redis.setValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        redis.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redis.setHashValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        redis.setConnectionFactory(redisConnectionFactory);
        redis.afterPropertiesSet();
        return redis;
    }
}

