/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.filter;

import com.digiwin.app.autoconfigure.DWContainerAutoConfiguration;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.gateway.filter.AllowAnonymousFilter;
import com.digiwin.gateway.filter.AuthenticationFilter;
import com.digiwin.gateway.filter.EaiRestfulUrlUtils;
import com.digiwin.gateway.filter.ExceptionFilter;
import com.digiwin.gateway.filter.LogContextFilter;
import com.digiwin.gateway.filter.SidecarProtocalFilter;
import com.digiwin.gateway.filter.StandardHeaderFilter;
import com.digiwin.gateway.filter.TokenAllowAnonymousFilter;
import com.digiwin.gateway.filter.TokenFilter;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@AutoConfigureAfter(value={DWContainerAutoConfiguration.class})
public class FilterConfiguration {
    private static final int SIDECAR_PROTOCAL_FILTER_ORDER = Integer.MIN_VALUE;
    private static final int STANDARD_HEADER_FILTER_ORDER = -2147483647;
    private static final int ALLOW_ANONYMOUS_FILTER_ORDER = 100000;
    public static final int TOKEN_FILTER_ORDER = 100001;
    public static final int LOG_CONTEXT_FILTER_ORDER = 100002;
    private static final int CAC_FILTER_ORDER = 100003;

    @Configuration
    @ConditionalOnMissingBean(value={ExceptionFilter.class})
    public static class ExceptionConfiguration {
        @Bean
        public ExceptionFilter exceptionFilter() {
            return new ExceptionFilter();
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={StandardHeaderFilter.class})
    public static class StandardOutputConfiguration {
        @Bean
        @DependsOn(value={"dw-data-permission-controller"})
        public FilterRegistrationBean<StandardHeaderFilter> standardHeaderFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)new StandardHeaderFilter());
            registration.addUrlPatterns(new String[]{"/restful/*"});
            registration.addUrlPatterns(StandardHeaderFilter.getExtraUrlPatterns());
            registration.setOrder(-2147483647);
            return registration;
        }
    }

    @Configuration
    @AutoConfigureAfter(value={DWContainerAutoConfiguration.class})
    public static class TokenConfiguration {
        private String[] urlPatterns = new String[]{"/restful/service/*", "/restful/standard/*", EaiRestfulUrlUtils.getUrl(), EaiRestfulUrlUtils.getCallbackUrl()};

        @ConditionalOnMissingBean(value={AllowAnonymousFilter.class})
        @Bean
        public AllowAnonymousFilter restfulAllowAnonymousFilter() {
            return new TokenAllowAnonymousFilter();
        }

        @Bean
        @ConditionalOnClass(value={AllowAnonymous.class})
        public FilterRegistrationBean<AllowAnonymousFilter> allowAnonymousFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)this.restfulAllowAnonymousFilter());
            registration.addUrlPatterns(this.urlPatterns);
            registration.setOrder(100000);
            return registration;
        }

        @ConditionalOnMissingBean(value={AuthenticationFilter.class})
        @Bean
        public AuthenticationFilter restfulTokenFilterBean() {
            return new TokenFilter();
        }

        @Bean
        public FilterRegistrationBean<AuthenticationFilter> restfulTokenFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)this.restfulTokenFilterBean());
            registration.addUrlPatterns(this.urlPatterns);
            registration.setOrder(100001);
            return registration;
        }

        @Bean
        public LogContextFilter restfulLogContextFilterBean() {
            return new LogContextFilter();
        }

        @Bean
        public FilterRegistrationBean<LogContextFilter> restfulLogContextFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)this.restfulLogContextFilterBean());
            registration.addUrlPatterns(this.urlPatterns);
            registration.setOrder(100002);
            return registration;
        }
    }

    @Configuration
    public static class SidecarProtocalConfiguration {
        @Bean
        public FilterRegistrationBean<SidecarProtocalFilter> sidecarProtocalFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)new SidecarProtocalFilter());
            registration.addUrlPatterns(new String[]{"/sidecar/*"});
            registration.setOrder(Integer.MIN_VALUE);
            return registration;
        }
    }
}

