/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.common.DWApplicationClassLoader;
import com.digiwin.app.dao.filter.DWFieldValueFilter;
import com.digiwin.app.dao.filter.DWSQLFilterChain;
import com.digiwin.app.dao.filter.DWSQLManagementFieldFilter;
import com.digiwin.app.dao.filter.DWSQLTenantIsolationFilter;
import com.digiwin.app.dao.filter.IDWManagementFieldResolver;
import com.digiwin.app.dao.filter.IDWSQLFilter;
import com.digiwin.app.dao.properties.DWDaoProperties;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@DependsOn(value={"dw-dao-properties"})
public class DWSQLFilterChainAutoConfiguration {
    @Bean(value={"dw-sqlFilterChain"})
    public DWSQLFilterChain getSQLFilterChain() throws Exception {
        List<IDWSQLFilter> filters = this.getCustomFilters();
        if (filters == null) {
            DWSQLManagementFieldFilter filter;
            filters = new ArrayList<IDWSQLFilter>();
            if (DWSQLManagementFieldFilter.isEnabled()) {
                filter = DWSQLFilterChainAutoConfiguration.getDefaultMgmtFieldSQLFilter();
                filters.add((IDWSQLFilter)filter);
            }
            filter = new DWSQLTenantIsolationFilter();
            filters.add((IDWSQLFilter)filter);
            DWFieldValueFilter dwFieldValueFilter = new DWFieldValueFilter();
            filters.add((IDWSQLFilter)dwFieldValueFilter);
            IDWSQLFilter dataPermSqlFilter = DWSQLFilterChainAutoConfiguration.getDataPermissionSQLFilter();
            if (dataPermSqlFilter != null) {
                filters.add(dataPermSqlFilter);
            }
        }
        DWSQLFilterChain chain = new DWSQLFilterChain(filters);
        return chain;
    }

    private static IDWManagementFieldResolver getResolver() throws Exception {
        String mgmtFieldResolverClazz = DWDaoProperties.getDefaultProperties().getMgmtFieldProperties().getMgmtFieldResolver();
        Class resolverClass = DWApplicationClassLoader.getInstance().loadClass(mgmtFieldResolverClazz);
        return (IDWManagementFieldResolver)resolverClass.newInstance();
    }

    private static DWSQLManagementFieldFilter getDefaultMgmtFieldSQLFilter() throws Exception {
        IDWManagementFieldResolver resolver = DWSQLFilterChainAutoConfiguration.getResolver();
        DWSQLManagementFieldFilter filter = new DWSQLManagementFieldFilter(resolver);
        return filter;
    }

    private static IDWSQLFilter getDataPermissionSQLFilter() throws Exception {
        IDWSQLFilter result = null;
        String dataPermSqlFilterClassName = DWDaoProperties.getDefaultProperties().getDaoSqlFilterProperties().getDataPermSqlFilter();
        if (dataPermSqlFilterClassName != null) {
            Class dataPermSqlFilterClass = DWApplicationClassLoader.getInstance().loadClass(dataPermSqlFilterClassName);
            result = (IDWSQLFilter)dataPermSqlFilterClass.newInstance();
        }
        return result;
    }

    private List<IDWSQLFilter> getCustomFilters() throws Exception {
        ArrayList<DWSQLManagementFieldFilter> customFilters = null;
        String dwsqlFilterChianCustom = DWDaoProperties.getDefaultProperties().getDaoSqlFilterProperties().getDwsqlFilterChianCustom();
        if (dwsqlFilterChianCustom != null && dwsqlFilterChianCustom.toLowerCase().startsWith("true:")) {
            String[] parts;
            customFilters = new ArrayList<DWSQLManagementFieldFilter>();
            String customFiltersString = dwsqlFilterChianCustom.substring("true:".length());
            for (String clazzString : parts = customFiltersString.split(",")) {
                Class clazz = DWApplicationClassLoader.getInstance().loadClass(clazzString);
                Object instance = clazz == DWSQLManagementFieldFilter.class ? DWSQLFilterChainAutoConfiguration.getDefaultMgmtFieldSQLFilter() : (IDWSQLFilter)clazz.newInstance();
                customFilters.add((DWSQLManagementFieldFilter)instance);
            }
        }
        return customFilters;
    }
}

