/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.event;

import com.digiwin.app.autoconfigure.condition.DWModularModeCondition;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.common.config.ConfigPolicy;
import com.digiwin.app.common.config.ConfigPool;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;

public class DWApolloApplicationListener
implements SmartApplicationListener {
    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ApplicationStartingEvent.class.isAssignableFrom(eventType) || ApplicationStartedEvent.class.isAssignableFrom(eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationStartingEvent) {
            if (!DWModularModeCondition.isModularMode()) {
                return;
            }
            Log log = LogFactory.getLog(DWApolloApplicationListener.class);
            log.info((Object)"*****DAP Modular Mode starting...*****");
            this.initConfigPool();
        } else if (event instanceof ApplicationStartedEvent) {
            Log log = LogFactory.getLog(DWApolloApplicationListener.class);
            if (!DWModularModeCondition.isModularMode()) {
                return;
            }
            log.info((Object)"*****DAP Modular Mode started.*****");
            ConfigPool pool = ConfigPool.getInstance();
            log.info((Object)pool);
            log.info((Object)("config center url: " + System.getProperty("configCenterUrl", "")));
            log.info((Object)("config center app ID: " + System.getProperty("app.id", "")));
            log.info((Object)("platform version: " + System.getProperty("platform.version", "")));
            log.info((Object)("application version: " + System.getProperty("application.version", "")));
            log.info((Object)("config center group app ID: " + System.getProperty("group.app.id", "")));
        }
    }

    public int getOrder() {
        return -2147483630;
    }

    private void initConfigPool() {
        String appIdFromProperties;
        ConfigPool pool = new ConfigPool();
        ConfigPool.setInstance((ConfigPool)pool);
        String configCenterUrl = DWApplicationConfigUtils.getProperty((String)"configCenterUrl", (String)"");
        String configPolicy = DWApplicationConfigUtils.getProperty((String)"configPolicy", (String)"local_first");
        String isRemoteConfigOn = DWApplicationConfigUtils.getProperty((String)"isRemoteConfigOn", (String)"false");
        String isGroupConfigOn = DWApplicationConfigUtils.getProperty((String)"isGroupConfigOn", (String)"false");
        String configGroup = DWApplicationConfigUtils.getProperty((String)"configGroup", (String)"");
        if (StringUtils.isBlank((CharSequence)configCenterUrl)) {
            return;
        }
        Map<String, String> env = System.getenv();
        String appIdFromEnv = env.getOrDefault("APPIMAGENAME", appIdFromProperties = DWApplicationConfigUtils.getProperty((String)"APPIMAGENAME", (String)""));
        String appId = DWApplicationConfigUtils.getProperty((String)"CUSTOM_APPIMAGENAME", (String)appIdFromEnv);
        if (StringUtils.isBlank((CharSequence)appId)) {
            return;
        }
        String platformVersionFromProperties = DWApplicationConfigUtils.getProperty((String)"PLATFORM", (String)"");
        String platformVersionFromEnv = env.getOrDefault("PLATFORM", platformVersionFromProperties);
        String platformVersion = DWApplicationConfigUtils.getProperty((String)"CUSTOM_PLATFORM", (String)platformVersionFromEnv);
        if (StringUtils.isBlank((CharSequence)platformVersion)) {
            return;
        }
        String applicationVersionFromProperties = DWApplicationConfigUtils.getProperty((String)"SMALLVERSION", (String)"");
        String applicationVersionFromEnv = env.getOrDefault("SMALLVERSION", applicationVersionFromProperties);
        String applicationVersion = DWApplicationConfigUtils.getProperty((String)"CUSTOM_SMALLVERSION", (String)applicationVersionFromEnv);
        if (StringUtils.isBlank((CharSequence)applicationVersion)) {
            return;
        }
        if (configCenterUrl.contains("test") || configCenterUrl.contains("dev")) {
            System.setProperty("env", "dev");
            System.setProperty("dev_meta", configCenterUrl);
        } else {
            System.setProperty("env", "pro");
            System.setProperty("pro_meta", configCenterUrl);
        }
        System.setProperty("configCenterUrl", configCenterUrl);
        System.setProperty("app.id", appId);
        System.setProperty("platform.version", platformVersion);
        System.setProperty("application.version", applicationVersion);
        System.setProperty("group.app.id", configGroup);
        System.setProperty("group.version", "default");
        System.setProperty("apollo.loadConfigQPS", "20000");
        if (StringUtils.isBlank((CharSequence)configGroup)) {
            isGroupConfigOn = "false";
        }
        pool.init(ConfigPolicy.fromString((String)configPolicy), Boolean.valueOf(isRemoteConfigOn).booleanValue(), Boolean.valueOf(isGroupConfigOn).booleanValue());
    }
}

