/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.DWDaoDynamicDataSourceConfiguration;
import com.digiwin.app.autoconfigure.condition.DWDbEnableCondition;
import com.digiwin.app.common.DWAdapterConfigUtils;
import com.digiwin.app.dao.DWDaoImpl;
import com.digiwin.app.dao.dialect.DWMySQLDialect;
import com.digiwin.app.dao.dialect.DWSQLDialect;
import com.digiwin.app.dao.properties.DWDaoDataSetProperties;
import com.digiwin.app.dao.properties.DWDaoDataSourceProperties;
import com.digiwin.app.dao.properties.DWDaoMgmtFieldProperties;
import com.digiwin.app.dao.properties.DWDaoProperties;
import com.digiwin.app.dao.properties.DWDaoSqlFilterProperties;
import com.digiwin.app.data.generator.DWFieldValueGeneratorEnum;
import com.digiwin.app.data.generator.DWFieldValueGeneratorFactory;
import com.digiwin.app.data.generator.DWSQLDateValueGenerator;
import com.digiwin.app.data.generator.DWSQLTimeValueGenerator;
import com.digiwin.app.data.generator.DWSQLTimestampValueGenerator;
import com.digiwin.app.data.generator.DWTenantsidValueGenerator;
import com.digiwin.app.data.generator.DWUUIDValueGenerator;
import com.digiwin.app.data.generator.IDWFieldValueGenerator;
import com.digiwin.app.log.utils.DWLogUtils;
import io.seata.rm.datasource.DataSourceProxy;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

@Configuration
@Import(value={DWDaoDynamicDataSourceConfiguration.class})
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class DWDaoAutoConfiguration {
    DWDaoProperties daoProperties;

    @Bean(value={"dw-dao-properties"})
    public DWDaoProperties daoProperties(Environment environment) {
        this.daoProperties = new DWDaoProperties();
        DWDaoMgmtFieldProperties mgmtFieldProperties = new DWDaoMgmtFieldProperties();
        DWDaoDataSetProperties dataSetProperties = new DWDaoDataSetProperties();
        DWDaoSqlFilterProperties daoSqlFilterProperties = new DWDaoSqlFilterProperties();
        mgmtFieldProperties.setMgmtFieldAliasName(environment.getProperty("mgmtFieldAliasName", ""));
        mgmtFieldProperties.setMgmtFieldEnabled(Boolean.parseBoolean(environment.getProperty("mgmtFieldEnabled", "false")));
        mgmtFieldProperties.setMgmtFieldIgnoreCustomValue(Boolean.parseBoolean(environment.getProperty("mgmtFieldIgnoreCustomValue", "true")));
        mgmtFieldProperties.setMgmtFieldResolver(environment.getProperty("mgmtFieldResolver", "com.digiwin.app.dao.filter.DWProfileManagementFieldResolver"));
        mgmtFieldProperties.setMgmtFieldUpdateMappings(environment.getProperty("mgmtFieldUpdateMappings"));
        mgmtFieldProperties.setMgmtFieldInsertMappings(environment.getProperty("mgmtFieldInsertMappings"));
        dataSetProperties.setDwdaoCalculateMaxSeqEnabled(Boolean.parseBoolean(environment.getProperty("dwdaoCalculateMaxSeqEnabled", "false")));
        dataSetProperties.setDwdaoCalculateMaxSeqFieldName(environment.getProperty("dwdaoCalculateMaxSeqFieldName", "seq"));
        dataSetProperties.setDwdaoSelectVersionFieldEnabled(Boolean.parseBoolean(environment.getProperty("dwdaoSelectVersionFieldEnabled", "false")));
        dataSetProperties.setDwdaoInsertDefaultValueFromMetadata(Boolean.parseBoolean(environment.getProperty("dap.dwdao.insert.default-value-from-metadata", "false")));
        daoSqlFilterProperties.setDataPermSqlFilter(environment.getProperty("dataPermSqlFilter"));
        daoSqlFilterProperties.setDwsqlFilterChianCustom(environment.getProperty("dwsqlFilterChianCustom"));
        this.daoProperties.setMgmtFieldProperties(mgmtFieldProperties);
        this.daoProperties.setDataSetProperties(dataSetProperties);
        this.daoProperties.setDaoSqlFilterProperties(daoSqlFilterProperties);
        DWDaoProperties.setDefaultDaoProperties((DWDaoProperties)this.daoProperties);
        return this.daoProperties;
    }

    @Bean(value={"dw-datasource-properties"})
    public DWDaoDataSourceProperties dataSourceProperties(Environment environment) {
        DWDaoDataSourceProperties dataSourceProperties = new DWDaoDataSourceProperties();
        dataSourceProperties.setDbConnectionInitialSize(Integer.parseInt(environment.getProperty("dbConnectionInitialSize")));
        dataSourceProperties.setDbConnectionMaxIdle(environment.getProperty("dbConnectionMaxIdle") == null ? null : Integer.valueOf(Integer.parseInt(environment.getProperty("dbConnectionMaxIdle"))));
        dataSourceProperties.setDbConnectionMaxTotal(Integer.parseInt(environment.getProperty("dbConnectionMaxTotal")));
        dataSourceProperties.setDbConnectionMaxWaitMillis(Integer.parseInt(environment.getProperty("dbConnectionMaxWaitMillis")));
        dataSourceProperties.setDbConnectionMinIdle(Integer.parseInt(environment.getProperty("dbConnectionMinIdle")));
        dataSourceProperties.setDbPassword(environment.getProperty("dbPassword"));
        dataSourceProperties.setDbUrl(environment.getProperty("dbUrl"));
        dataSourceProperties.setDbUsername(environment.getProperty("dbUsername"));
        dataSourceProperties.setDwDaoUnderScoreToCamelCase(Boolean.parseBoolean(environment.getProperty("dwDaoUnderScoreToCamelCase", "true")));
        dataSourceProperties.setJdbcDriverClassName(environment.getProperty("jdbcDriverClassName"));
        dataSourceProperties.setSeataDatasourceProxyEnable(Boolean.parseBoolean(environment.getProperty("seata.dwdao.datasource.proxy.enabled", "false")));
        dataSourceProperties.setJdbcDriverClassName(environment.getProperty("jdbcDriverClassName"));
        DWDaoDataSourceProperties.setDefaultProperties((DWDaoDataSourceProperties)dataSourceProperties);
        return dataSourceProperties;
    }

    @Deprecated
    @Bean(name={"dw-dataSource"})
    @ConditionalOnMissingBean(name={"dw-dataSource"})
    @Conditional(value={DWDbEnableCondition.class})
    public DataSource basicDataSource(DWAdapterConfigUtils adapterConfigUtils, @Qualifier(value="dw-datasource-properties") DWDaoDataSourceProperties dataSourceProperties) {
        String driverClassName = dataSourceProperties.getJdbcDriverClassName();
        String dbUrl = dataSourceProperties.getDbUrl();
        String dbUsername = dataSourceProperties.getDbUsername();
        String dbPassword = dataSourceProperties.getDbPassword();
        int dbConnectionInitialSize = dataSourceProperties.getDbConnectionInitialSize();
        int dbConnectionMinIdle = dataSourceProperties.getDbConnectionMinIdle();
        Integer dbConnectionMaxIdle = dataSourceProperties.getDbConnectionMaxIdle();
        int dbConnectionMaxTotal = dataSourceProperties.getDbConnectionMaxTotal();
        int dbConnectionMaxWaitMillis = dataSourceProperties.getDbConnectionMaxWaitMillis();
        BasicDataSource basicDataSource = new BasicDataSource();
        basicDataSource.setDriverClassName(driverClassName);
        basicDataSource.setUrl(dbUrl);
        basicDataSource.setUsername(dbUsername);
        basicDataSource.setPassword(dbPassword);
        basicDataSource.setInitialSize(dbConnectionInitialSize);
        basicDataSource.setMinIdle(dbConnectionMinIdle);
        if (dbConnectionMaxIdle != null) {
            basicDataSource.setMaxIdle(dbConnectionMaxIdle.intValue());
        } else {
            basicDataSource.setMaxIdle(dbConnectionMaxTotal);
        }
        basicDataSource.setMaxTotal(dbConnectionMaxTotal);
        basicDataSource.setMaxWaitMillis((long)dbConnectionMaxWaitMillis);
        return basicDataSource;
    }

    @Bean(name={"dw-proxyDataSource"})
    @Primary
    @ConditionalOnBean(name={"dw-dataSource"})
    public DataSource transactionAwareDataSourceProxy(@Qualifier(value="dw-dataSource") DataSource dataSource, @Qualifier(value="dw-datasource-properties") DWDaoDataSourceProperties dataSourceProperties) {
        boolean seataDsProxyEnabled = dataSourceProperties.isSeataDatasourceProxyEnable();
        Object returnDataSourceProxy = DWLogUtils.getSeataEnabled() && BooleanUtils.toBoolean((Boolean)seataDsProxyEnabled) ? new DataSourceProxy(dataSource) : new TransactionAwareDataSourceProxy(dataSource);
        return returnDataSourceProxy;
    }

    @Bean(name={"dw-queryRunner"})
    @Primary
    @ConditionalOnBean(name={"dw-dataSource"})
    public QueryRunner queryRunner(@Qualifier(value="dw-proxyDataSource") DataSource dataSourceProxy) {
        QueryRunner queryRunner = new QueryRunner(dataSourceProxy);
        return queryRunner;
    }

    @Bean(name={"dw-sqlDialect"})
    @ConditionalOnMissingBean(value={DWSQLDialect.class})
    public DWSQLDialect dwSqlDialect(Environment environment) throws Exception {
        DWMySQLDialect dialect = null;
        String dialectClassName = (String)environment.getProperty("dap.dwdao.default.dialect.class", String.class, null);
        if (dialectClassName == null) {
            dialect = new DWMySQLDialect();
        } else {
            Class<?> dialectClass = this.getClass().getClassLoader().loadClass(dialectClassName);
            dialect = (DWSQLDialect)dialectClass.newInstance();
        }
        return dialect;
    }

    @Bean(name={"dw-dao"})
    @Primary
    @Conditional(value={DWDbEnableCondition.class})
    public DWDaoImpl dwDaoImpl(@Qualifier(value="dw-queryRunner") QueryRunner queryRunner, @Qualifier(value="dw-datasource-properties") DWDaoDataSourceProperties dataSourceProperties, @Qualifier(value="dw-sqlDialect") DWSQLDialect dialect, @Qualifier(value="dw-dao-properties") DWDaoProperties daoProperties) {
        DWDaoImpl dao = new DWDaoImpl(queryRunner);
        dao.setDialect(dialect);
        dao.setProperties(daoProperties);
        boolean mapUnderscoreToCamelCase = true;
        boolean settingValue = dataSourceProperties.isDwDaoUnderScoreToCamelCase();
        if (!settingValue) {
            mapUnderscoreToCamelCase = false;
        }
        dao.setMapUnderscoreToCamelCase(mapUnderscoreToCamelCase);
        return dao;
    }

    @Bean(name={"dw-transactionManager"})
    @Primary
    @ConditionalOnBean(name={"dw-dataSource"})
    public DataSourceTransactionManager dataSourceTransactionManager(@Qualifier(value="dw-proxyDataSource") DataSource dataSourceProxy) {
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager();
        dataSourceTransactionManager.setDataSource(dataSourceProxy);
        return dataSourceTransactionManager;
    }

    @Bean(name={"dw-fieldValueGeneratorFactory"})
    public DWFieldValueGeneratorFactory fieldValueGeneratorFactory() {
        DWFieldValueGeneratorFactory factory = new DWFieldValueGeneratorFactory();
        factory.addGenerator(DWFieldValueGeneratorEnum.UUID.getValue(), (IDWFieldValueGenerator)new DWUUIDValueGenerator());
        factory.addGenerator(DWFieldValueGeneratorEnum.SQL_DATE.getValue(), (IDWFieldValueGenerator)new DWSQLDateValueGenerator());
        factory.addGenerator(DWFieldValueGeneratorEnum.SQL_TIME.getValue(), (IDWFieldValueGenerator)new DWSQLTimeValueGenerator());
        factory.addGenerator(DWFieldValueGeneratorEnum.SQL_TIMESTAMP.getValue(), (IDWFieldValueGenerator)new DWSQLTimestampValueGenerator());
        factory.addGenerator(DWFieldValueGeneratorEnum.TENANTSID.getValue(), (IDWFieldValueGenerator)new DWTenantsidValueGenerator());
        DWFieldValueGeneratorFactory.setInstance((DWFieldValueGeneratorFactory)factory);
        return factory;
    }
}

