/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.DWContainerAutoConfiguration;
import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWFullParametersMatchProcessor;
import com.digiwin.app.container.DWMethodMatchProcessor;
import com.digiwin.app.container.DWOneParameterMatchProcessor;
import com.digiwin.app.container.DWServiceInvocationProcessor;
import com.digiwin.app.container.local.DWLocalHeaderRepository;
import com.digiwin.app.container.local.DWLocalServiceRepository;
import com.digiwin.app.container.local.DWSimpleServiceParser;
import com.digiwin.app.module.DWModuleServiceInvocationProcessor;
import com.digiwin.gateway.filter.DWMethodLocateFilter;
import com.digiwin.gateway.filter.RequestStandardizationFilter;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnClass(value={DWLocalHeaderRepository.class})
@AutoConfigureBefore(value={DWContainerAutoConfiguration.class})
public class DWDefaultServiceAutoConfiguration {
    private static final int SERVICE_URL_RULE_FILTER_ORDER = 0;
    private static final int DWHEADER_LOCATE_FILTER_ORDER = 1;
    private static final int DWMETHOD_LOCATE_FILTER_ORDER = 2;
    private static final int REQUEST_STANDARDIZATION_FILTER_ORDER = 100002;

    @Bean(value={"localHeaderRepository"})
    public DWLocalHeaderRepository getDWLocalHeaderRepository(Environment environment) {
        DWLocalHeaderRepository repository = new DWLocalHeaderRepository();
        repository.addMatchProcessor((DWMethodMatchProcessor)new DWFullParametersMatchProcessor());
        boolean oneParamMatcher = Boolean.parseBoolean(environment.getProperty("dap.container.local.matcher.one-param", "false"));
        if (oneParamMatcher) {
            repository.addMatchProcessor((DWMethodMatchProcessor)new DWOneParameterMatchProcessor());
        }
        return repository;
    }

    @Bean(value={"localServiceRepository"})
    public DWLocalServiceRepository getDWLocalServiceRepository() {
        return new DWLocalServiceRepository();
    }

    @Bean(value={"DWSimpleServiceParser"})
    public DWSimpleServiceParser getDWSimpleServiceParser(DWLocalHeaderRepository localHeaderRepository, DWLocalServiceRepository localServiceRepository) {
        return new DWSimpleServiceParser(localHeaderRepository, localServiceRepository);
    }

    @Bean(value={"DWModuleServiceInvocationProcessor"})
    public DWServiceInvocationProcessor getDWServiceInvocationProcessor() {
        return new DWModuleServiceInvocationProcessor();
    }

    @Configuration
    @ConditionalOnClass(value={DWContainerContext.class})
    @AutoConfigureAfter(value={DWContainerAutoConfiguration.class})
    public static class RestfulServiceConfiguration {
        @Bean
        public DWMethodLocateFilter dwMethodLocateFilterBean() {
            return new DWMethodLocateFilter();
        }

        @Bean
        public FilterRegistrationBean<DWMethodLocateFilter> dwMethodLocateFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)this.dwMethodLocateFilterBean());
            registration.addUrlPatterns(new String[]{"/restful/service/*"});
            registration.setOrder(2);
            return registration;
        }

        @Bean
        public FilterRegistrationBean<RequestStandardizationFilter> requestStandardizationFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)new RequestStandardizationFilter());
            registration.addUrlPatterns(new String[]{"/restful/service/*"});
            registration.setOrder(100002);
            return registration;
        }
    }
}

