/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.common.DWAdapterConfigUtils;
import com.digiwin.http.client.DWConnectKeepAliveStrategy;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWHttpClientProperties;
import com.digiwin.http.client.DWHttpRetrySimpleBackoff;
import com.digiwin.http.serializer.DWHttpRetryBackoffDeserializer;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@Configuration
@DependsOn(value={"dw-json-config"})
@AutoConfigureOrder(value=-2147483648)
public class DWHttpClientAutoConfiguration {
    @Bean(value={"dw-http-client-properties"})
    public DWHttpClientProperties getHttpClientProperties(Environment environment) {
        DWHttpClientProperties properties = new DWHttpClientProperties();
        String connPropertyPrefix = environment.getProperty("dap.http.client.config.prefix", "dw") + "HttpConnectionConfig";
        properties.setMaxTotal(Integer.parseInt(environment.getProperty(connPropertyPrefix + "MaxTotal", "20")));
        properties.setDefaultMaxPerRoute(Integer.parseInt(environment.getProperty(connPropertyPrefix + "DefaultMaxPerRoute", "10")));
        properties.setValidateAfterInactivity(Integer.parseInt(environment.getProperty(connPropertyPrefix + "ValidateAfterInactivity", "2000")));
        String requestPropertyPrefix = environment.getProperty("dap.http.client.config.prefix", "dw") + "HttpRequestConfig";
        properties.setConnectionRequestTimeout(Integer.parseInt(environment.getProperty(requestPropertyPrefix + "ConnectionRequestTimeout", "-1")));
        properties.setConnectTimeout(Integer.parseInt(environment.getProperty(requestPropertyPrefix + "ConnectTimeout", "-1")));
        properties.setSocketTimeout(Integer.parseInt(environment.getProperty(requestPropertyPrefix + "SocketTimeout", "-1")));
        String appId = environment.getProperty("appId");
        properties.setAppId(appId);
        properties.setIamUrl(environment.getProperty("iamUrl"));
        properties.setIamApToken(environment.getProperty("iamApToken", ""));
        properties.setTokenMode(environment.getProperty("serverHttpTokenmode", "IAM"));
        String keepAliveTimeoutString = environment.getProperty("dwHttpKeepAliveTimeout");
        if (keepAliveTimeoutString != null) {
            DWConnectKeepAliveStrategy connectionKeepAliveStrategy = new DWConnectKeepAliveStrategy();
            connectionKeepAliveStrategy.setKeepAliveTimeout((long)Integer.parseInt(keepAliveTimeoutString));
            properties.setConnectionKeepAliveStrategy((ConnectionKeepAliveStrategy)connectionKeepAliveStrategy);
        }
        String evictExpiredConnectionsString = environment.getProperty("dwHttpEvictExpiredConnections");
        properties.setEvictExpiredConnections(Boolean.parseBoolean(evictExpiredConnectionsString));
        String evictIdleConnectionsMaxIdleTimeString = environment.getProperty("dwHttpEvictIdleConnectionsMaxIdleTime");
        if (evictIdleConnectionsMaxIdleTimeString != null) {
            properties.setEvictIdleConnectionsMaxIdleTime(Long.valueOf(Long.parseLong(evictIdleConnectionsMaxIdleTimeString)));
        }
        DWHttpClientProperties.setProperties((DWHttpClientProperties)properties);
        return properties;
    }

    @Bean(value={"dw-httpclient-source"})
    public HttpClient getHttpClientSource(DWHttpClientProperties httpClientProperties) {
        return DWHttpClient.createHttpClient((DWHttpClientProperties)httpClientProperties);
    }

    @Bean(value={"dw-httpclient"})
    @DependsOn(value={"dw-http-client-properties", "dw-httpclient-retry-backoff-deserializer"})
    public DWHttpClient getDWHttpClient(@Qualifier(value="dw-httpclient-source") HttpClient source, DWAdapterConfigUtils adapterConfigUtils) {
        return new DWHttpClient(source);
    }

    @Bean(value={"dw-httpclient-retry-backoff-deserializer"})
    public DWHttpRetryBackoffDeserializer getBackoffDeserializer(DWAdapterConfigUtils adapterConfigUtils) {
        DWHttpRetryBackoffDeserializer.register((String)"simple", DWHttpRetrySimpleBackoff.class);
        return new DWHttpRetryBackoffDeserializer();
    }
}

