/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.filter;

import com.digiwin.app.autoconfigure.DWContainerAutoConfiguration;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.gateway.filter.AllowAnonymousFilter;
import com.digiwin.gateway.filter.AuthenticationFilter;
import com.digiwin.gateway.filter.DWCrossDomainProperties;
import com.digiwin.gateway.filter.ExceptionFilter;
import com.digiwin.gateway.filter.LogContextFilter;
import com.digiwin.gateway.filter.SidecarProtocalFilter;
import com.digiwin.gateway.filter.StandardHeaderFilter;
import com.digiwin.gateway.filter.TokenAllowAnonymousFilter;
import com.digiwin.gateway.filter.TokenFilter;
import com.digiwin.gateway.fuse.config.DapPropertiesOptionKey;
import com.digiwin.gateway.service.permission.DWSecurityContextInitFilter;
import com.digiwin.gateway.service.permission.config.DWServicePermissionConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.servlet.Filter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@Configuration
@AutoConfigureAfter(value={DWContainerAutoConfiguration.class})
public class FilterConfiguration {
    private static final int SIDECAR_PROTOCAL_FILTER_ORDER = Integer.MIN_VALUE;
    private static final int STANDARD_HEADER_FILTER_ORDER = -2147483647;
    private static final int ALLOW_ANONYMOUS_FILTER_ORDER = 100000;
    public static final int SECURITY_CONTEXT_INIT_FILTER_ORDER = 99999;
    public static final int TOKEN_FILTER_ORDER = 100001;
    public static final int LOG_CONTEXT_FILTER_ORDER = 100002;
    static final String KEY_SERVICE_PERMISSION_ON = "dap.service.permission.on";
    static final String KEY_TRUST_CHAIN_ON = "dap.trust.chain.on";
    static final String KEY_APP_ID = "appId";

    @Configuration
    @ConditionalOnMissingBean(value={ExceptionFilter.class})
    public static class ExceptionConfiguration {
        @Bean
        public ExceptionFilter exceptionFilter(ApplicationContext context) {
            ExceptionFilter exceptionFilter = new ExceptionFilter();
            String isAutoFuseHttpStatusCode = context.getEnvironment().getProperty(DapPropertiesOptionKey.isAutoFuseHttpStatusCode(), String.valueOf(true));
            exceptionFilter.setAutoFuseHttpStatusCode(Boolean.valueOf(isAutoFuseHttpStatusCode).booleanValue());
            return exceptionFilter;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={StandardHeaderFilter.class})
    public static class StandardOutputConfiguration {
        @Bean
        public DWCrossDomainProperties crossDomainProperties(Environment environment, ObjectProvider<List<DWCrossDomainProperties.UrlPatterns>> urlPatternsListProvider) {
            DWCrossDomainProperties crossDomainProperties = new DWCrossDomainProperties();
            List urlPatternsList = (List)urlPatternsListProvider.getIfAvailable(Collections::emptyList);
            for (DWCrossDomainProperties.UrlPatterns urlPatterns : urlPatternsList) {
                crossDomainProperties.addUrlPatterns(urlPatterns.get());
            }
            String allowOrigin = environment.getProperty("accessControlAllowOrigin", "*");
            String allowMethods = environment.getProperty("accessControlAllowMethods", "POST");
            String allowHeaders = environment.getProperty("accessControlAllowHeaders", "token");
            String maxAge = environment.getProperty("accessControlMaxAge", "86400");
            crossDomainProperties.put("Access-Control-Allow-Origin", allowOrigin).put("Access-Control-Allow-Headers", allowHeaders).put("Access-Control-Allow-Methods", allowMethods).put("Access-Control-Max-Age", maxAge);
            return crossDomainProperties;
        }

        @Bean
        public FilterRegistrationBean<StandardHeaderFilter> standardHeaderFilter(DWCrossDomainProperties properties) {
            StandardHeaderFilter standardHeaderFilterInstance = new StandardHeaderFilter(properties.getSettings());
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)standardHeaderFilterInstance);
            registration.addUrlPatterns(new String[]{"/restful/*"});
            registration.addUrlPatterns(properties.getUrlPatterns());
            registration.setOrder(-2147483647);
            return registration;
        }
    }

    @Configuration
    @AutoConfigureAfter(value={DWContainerAutoConfiguration.class})
    public static class TokenConfiguration {
        private List<String> urlPatterns = new ArrayList<String>();

        public TokenConfiguration() {
            this.registerUrlPatterns("/restful/service/*", "/restful/standard/*");
        }

        public void registerUrlPatterns(String ... extraPatterns) {
            Objects.requireNonNull(extraPatterns);
            this.urlPatterns.addAll(Arrays.asList(extraPatterns));
        }

        private String[] getUrlPatterns() {
            return this.urlPatterns.toArray(new String[this.urlPatterns.size()]);
        }

        @Bean
        @ConditionalOnMissingBean(value={AllowAnonymousFilter.class})
        public AllowAnonymousFilter restfulAllowAnonymousFilter() {
            return new TokenAllowAnonymousFilter();
        }

        @Bean
        @DependsOn(value={"DWEaiRestfulUrlProperties"})
        @ConditionalOnClass(value={AllowAnonymous.class})
        public FilterRegistrationBean<AllowAnonymousFilter> allowAnonymousFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)this.restfulAllowAnonymousFilter());
            registration.addUrlPatterns(this.getUrlPatterns());
            registration.setOrder(100000);
            return registration;
        }

        @ConditionalOnMissingBean(value={AuthenticationFilter.class})
        @Bean
        public AuthenticationFilter restfulTokenFilterBean() {
            return new TokenFilter();
        }

        @Bean
        @DependsOn(value={"DWEaiRestfulUrlProperties"})
        public FilterRegistrationBean<AuthenticationFilter> restfulTokenFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)this.restfulTokenFilterBean());
            registration.addUrlPatterns(this.getUrlPatterns());
            registration.setOrder(100001);
            return registration;
        }

        @Bean(value={"dw-service-permission-config"})
        public DWServicePermissionConfig dwServicePermissionConfig(Environment environment) {
            DWServicePermissionConfig config = new DWServicePermissionConfig();
            String validServicePermission = environment.getProperty(FilterConfiguration.KEY_SERVICE_PERMISSION_ON, String.valueOf(false));
            String openTrustChain = environment.getProperty(FilterConfiguration.KEY_TRUST_CHAIN_ON, String.valueOf(true));
            config.setValidServicePermission(Boolean.parseBoolean(validServicePermission));
            config.setOpenTrustChain(Boolean.parseBoolean(openTrustChain));
            config.setAppId(environment.getProperty(FilterConfiguration.KEY_APP_ID));
            return config;
        }

        @Bean
        @DependsOn(value={"dw-service-permission-config"})
        public DWSecurityContextInitFilter securityContextInitFilterBean() {
            return new DWSecurityContextInitFilter();
        }

        @Bean
        public FilterRegistrationBean<DWSecurityContextInitFilter> securityContextInitFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)this.securityContextInitFilterBean());
            registration.addUrlPatterns(this.getUrlPatterns());
            registration.setOrder(99999);
            return registration;
        }

        @Bean
        public LogContextFilter restfulLogContextFilterBean() {
            return new LogContextFilter();
        }

        @Bean
        public FilterRegistrationBean<LogContextFilter> restfulLogContextFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)this.restfulLogContextFilterBean());
            registration.addUrlPatterns(this.getUrlPatterns());
            registration.setOrder(100002);
            return registration;
        }
    }

    @Configuration
    public static class SidecarProtocalConfiguration {
        @Bean
        public FilterRegistrationBean<SidecarProtocalFilter> sidecarProtocalFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)new SidecarProtocalFilter());
            registration.addUrlPatterns(new String[]{"/sidecar/*"});
            registration.setOrder(Integer.MIN_VALUE);
            return registration;
        }
    }
}

