/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.persistconn.DWQueueConfiguration;
import com.digiwin.app.persistconn.DWQueueProperties;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class DWQueueAutoConfiguration {
    private static Log log = LogFactory.getLog(DWQueueAutoConfiguration.class);
    private static final String TAG = "[DWQueueAutoConfiguration] ";
    private static final String KEY_FALSE = "false";

    @Bean(value={"dw-queue-properties"})
    public DWQueueProperties queueProperties(Environment environment) {
        int retryIntervalSec;
        int retryTimes;
        DWQueueProperties properties = new DWQueueProperties();
        try {
            String retryTimesString = environment.getProperty("queueRetryTimes", "-1");
            String retryIntervalSecString = environment.getProperty("queueRetryIntervalSec", "-1");
            if (StringUtils.isBlank((CharSequence)retryTimesString) || Objects.equals("@queueRetryTimes@", retryTimesString)) {
                retryTimesString = "-1";
            }
            if (StringUtils.isBlank((CharSequence)retryIntervalSecString) || Objects.equals("@queueRetryIntervalSec@", retryIntervalSecString)) {
                retryIntervalSecString = "-1";
            }
            retryTimes = Integer.parseInt(retryTimesString);
            retryIntervalSec = Integer.parseInt(retryIntervalSecString);
        }
        catch (Exception e) {
            retryTimes = -1;
            retryIntervalSec = -1;
            log.error((Object)"[DWQueueAutoConfiguration]  error!", (Throwable)e);
        }
        properties.setRetryTimes(retryTimes);
        properties.setRetryIntervalSec(retryIntervalSec);
        String isHttps = environment.getProperty("queueSaasRabbitmqIsHttps", KEY_FALSE);
        if (StringUtils.isBlank((CharSequence)isHttps)) {
            isHttps = KEY_FALSE;
        }
        properties.setSaasRabbitmqIsHttps(Boolean.parseBoolean(isHttps));
        properties.setSaasRabbitmqHost(environment.getProperty("queueSaasRabbitmqHost", ""));
        String amqpPort = environment.getProperty("queueSaasRabbitmqAmqpPort", "5672");
        if (StringUtils.isBlank((CharSequence)amqpPort) || Objects.equals("@queueSaasRabbitmqAmqpPort@", amqpPort)) {
            amqpPort = "5672";
        }
        properties.setSaasRabbitmqAmqpPort(Integer.parseInt(amqpPort));
        String httpPort = environment.getProperty("queueSaasRabbitmqHttpPort", "15672");
        if (StringUtils.isBlank((CharSequence)httpPort) || Objects.equals("@queueSaasRabbitmqHttpPort@", httpPort)) {
            httpPort = "15672";
        }
        properties.setSaasRabbitmqHttpPort(Integer.parseInt(httpPort));
        properties.setSaasRabbitmqUsername(environment.getProperty("queueSaasRabbitmqUsername", ""));
        properties.setSaasRabbitmqPassword(environment.getProperty("queueSaasRabbitmqPassword", ""));
        properties.setQueueSaasTlsOn(Boolean.valueOf(environment.getProperty("queueSaasTlsOn", KEY_FALSE)).booleanValue());
        properties.setTenantProcessorHost(environment.getProperty("queueTenantProcessorHost", ""));
        properties.setTenantTlsOn(Boolean.valueOf(environment.getProperty("queueTenantTlsOn", KEY_FALSE)).booleanValue());
        return properties;
    }

    @Bean
    public DWQueueConfiguration queueConfiguration(DWQueueProperties properties) {
        DWQueueConfiguration.setProperties((DWQueueProperties)properties);
        DWQueueConfiguration queueConfiguration = new DWQueueConfiguration();
        queueConfiguration.queueRetrySetting();
        return queueConfiguration;
    }
}

