/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.condition.DWRedissonEnableCondition;
import com.digiwin.app.redisson.service.IDWRedissonPrefix;
import com.digiwin.app.redisson.service.impl.DWAppRedissonPrefix;
import com.digiwin.app.redisson.service.impl.DWTenantRedissonPrefix;
import com.digiwin.app.redisson.service.impl.DWUserIgnoreTenantRedissonPrefix;
import com.digiwin.app.redisson.service.impl.DWUserRedissonPrefix;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@Conditional(value={DWRedissonEnableCondition.class})
public class DWRedissonLockPrefixConfiguration {
    private static Log log = LogFactory.getLog(DWRedissonLockPrefixConfiguration.class);

    @Bean(value={"redisson-lock-prefix-app"})
    public IDWRedissonPrefix redissonAppPrefix(Environment environment) throws Exception {
        return new DWAppRedissonPrefix(environment);
    }

    @Bean(value={"redisson-lock-prefix-tenant"})
    public IDWRedissonPrefix redissonTenantPrefix(Environment environment) throws Exception {
        return new DWTenantRedissonPrefix(environment);
    }

    @Bean(value={"redisson-lock-prefix-user"})
    public IDWRedissonPrefix redissonUserPrefix(Environment environment) throws Exception {
        return new DWUserRedissonPrefix(environment);
    }

    @Bean(value={"redisson-lock-prefix-user-ignore-tenant"})
    public IDWRedissonPrefix redissonUserExcludeTenantPrefix(Environment environment) throws Exception {
        return new DWUserIgnoreTenantRedissonPrefix(environment);
    }
}

