/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.condition;

import java.util.Objects;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class DWCacheEnableCondition
implements Condition {
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return DWCacheEnableCondition.isCacheEnabled(context.getEnvironment());
    }

    public static boolean isCacheEnabled(Environment environment) {
        Objects.requireNonNull(environment);
        String redisHost = environment.getProperty("spring.redis.host");
        return redisHost != null && !redisHost.isEmpty();
    }
}

