/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.condition.DWMqEnableCondition;
import com.digiwin.app.serviceclient.mq.DWMq;
import com.digiwin.app.serviceclient.mq.DWMqInfo;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@Conditional(value={DWMqEnableCondition.class})
public class DWMqAutoConfiguration {
    @Bean(name={"dw-mq"})
    public DWMq mq(Environment environment) {
        String appId = environment.getProperty("appId");
        String basic = environment.getProperty("dwMqBasic");
        String protocol = environment.getProperty("dwMqProtocol", "http");
        String host = environment.getProperty("dwMqHost");
        String port = environment.getProperty("dwMqPort");
        String virtualHost = environment.getProperty("dwMqVirtualHost", "dwmq");
        String webPort = environment.getProperty("dwMqWebPort", "");
        DWMqInfo mqInfo = new DWMqInfo(basic, protocol, host, port, virtualHost, webPort);
        return new DWMq(appId, mqInfo);
    }
}

