/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.data.permission;

import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.data.permission.DWRowPermissionElement;
import com.digiwin.data.permission.DWRowPermissionElementDeserializer;
import com.digiwin.data.permission.controller.DWDataPermissionController;
import com.digiwin.data.permission.controller.DWDataPermissionMetadataJsonFileProvider;
import com.digiwin.data.permission.controller.DWDataPermissionSchemasParameters;
import com.digiwin.data.permission.controller.DWDataPermissionValuesParameters;
import com.digiwin.data.permission.controller.IDWDataPermissionMetadataProvider;
import com.digiwin.gateway.filter.DWCrossDomainProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@ConditionalOnClass(value={DWDataPermissionController.class})
public class DWDataPermissionAutoConfiguration {
    public static final String PATH_BASE = "/api/permission/data/";
    public static final String PATH_SCHEMAS = "/api/permission/data/schemas";
    public static final String PATH_VALUES = "/api/permission/data/values";

    @DependsOn(value={"dw-json-config"})
    @Bean(value={"dw-rowPermissionElementDeserializer"})
    public DWRowPermissionElementDeserializer getRowPermissionElementDeserializer() {
        DWRowPermissionElementDeserializer deserializer = new DWRowPermissionElementDeserializer();
        DWGsonProvider.registerTypeAdapter(DWRowPermissionElement.class, (Object)deserializer);
        return deserializer;
    }

    @Bean
    public DWCrossDomainProperties.UrlPatterns dwDataPermissionControllerUrlPatterns() {
        return new DWCrossDomainProperties.UrlPatterns(new String[]{PATH_SCHEMAS, PATH_VALUES});
    }

    @Bean(value={"dw-data-permission-controller"})
    public DWDataPermissionController createDWIAMDataPermissionController(RequestMappingHandlerMapping requestMappingHandlerMapping) throws Exception {
        DWDataPermissionController controller = new DWDataPermissionController();
        RequestMappingInfo eaiRestfulMappingInfo = RequestMappingInfo.paths((String[])new String[]{PATH_SCHEMAS}).methods(new RequestMethod[]{RequestMethod.GET}).produces(new String[]{"application/json;charset=UTF-8"}).build();
        requestMappingHandlerMapping.registerMapping((Object)eaiRestfulMappingInfo, (Object)controller, DWDataPermissionController.class.getDeclaredMethod("getSchemas", DWDataPermissionSchemasParameters.class));
        RequestMappingInfo eaiCallbackMappingInfo = RequestMappingInfo.paths((String[])new String[]{PATH_VALUES}).methods(new RequestMethod[]{RequestMethod.POST}).produces(new String[]{"application/json;charset=UTF-8"}).build();
        requestMappingHandlerMapping.registerMapping((Object)eaiCallbackMappingInfo, (Object)controller, DWDataPermissionController.class.getDeclaredMethod("getValues", DWDataPermissionValuesParameters.class));
        return controller;
    }

    @ConditionalOnMissingBean
    @Bean(value={"dw-data-permission-metadata-provider"})
    public IDWDataPermissionMetadataProvider createMetadataProvider() {
        return new DWDataPermissionMetadataJsonFileProvider();
    }
}

