/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.DWJsonAutoConfiguration;
import com.digiwin.app.autoconfigure.condition.DWGsonNumberProcessorEnableCondition;
import com.digiwin.app.json.DWJsonConfig;
import com.digiwin.app.json.processor.number.DWBigDecimalProcessor;
import com.digiwin.app.json.processor.number.DWDefaultNumberProcessor;
import com.digiwin.app.json.processor.number.DWDoubleProcessor;
import com.digiwin.app.json.processor.number.DWIntOrLongProcessor;
import com.digiwin.app.json.processor.number.DWNumberProcessor;
import com.digiwin.app.json.processor.number.DWStringProcessor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={DWJsonAutoConfiguration.class})
public class DWGsonNumberProcessorAutoConfiguration {
    @Bean(value={"dw-json-number-processor"})
    @Conditional(value={DWGsonNumberProcessorEnableCondition.class})
    public DWNumberProcessor dwNumberProcessor(@Qualifier(value="dw-json-config") DWJsonConfig jsonConfig) throws Exception {
        String numberProcessorAlias = DWJsonConfig.getNumberProcessorName();
        Class<?> numberProcessorClass = this.getNumberProcessorClass(numberProcessorAlias);
        return (DWNumberProcessor)numberProcessorClass.newInstance();
    }

    private Class<?> getNumberProcessorClass(String alias) {
        switch (alias.trim().toLowerCase()) {
            case "int": {
                return DWIntOrLongProcessor.class;
            }
            case "string": {
                return DWStringProcessor.class;
            }
            case "double": {
                return DWDoubleProcessor.class;
            }
            case "decimal": {
                return DWBigDecimalProcessor.class;
            }
        }
        return DWDefaultNumberProcessor.class;
    }
}

