/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.condition;

import com.digiwin.app.autoconfigure.condition.DWDbEnableCondition;
import com.digiwin.app.autoconfigure.condition.DWDefaultDWDaoEnableCondition;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class DWScheduleEnableCondition
implements Condition {
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return DWScheduleEnableCondition.isScheduleEnabled(context.getEnvironment());
    }

    public static boolean isScheduleEnabled(Environment environment) {
        if (!DWDbEnableCondition.isDbEnabled((Environment)environment) && !DWDefaultDWDaoEnableCondition.isEnabled((Environment)environment)) {
            return false;
        }
        String scheduleEnabled = environment.getProperty("scheduleEnabled", "false");
        return !scheduleEnabled.equalsIgnoreCase("false");
    }
}

