/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.startup;

import com.digiwin.app.autoconfigure.condition.DWEAIServiceInstanceCondition;
import com.digiwin.app.autoconfigure.condition.DWMqEnableCondition;
import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.eai.fasynctask.compensation.CompensationService;
import com.digiwin.app.eai.fasynctask.compensation.CompensationStartUpEvent;
import com.digiwin.app.eai.serviceinstance.ServiceInstanceService;
import com.digiwin.app.eai.serviceinstance.ServiceInstanceStartUpEvent;
import com.digiwin.app.module.spring.DWModuleSpringUtils;
import com.digiwin.app.serviceclient.mq.DWMq;
import com.digiwin.app.serviceclient.mq.DWMqStartupEvent;
import com.digiwin.gateway.ApplicationStartup;
import com.digiwin.gateway.OnLoadMethodsStartupEvent;
import java.util.List;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@Order(value=-2147483648)
public class StartupConfiguration
implements DisposableBean {
    private volatile boolean running = false;

    @Conditional(value={DWMqEnableCondition.class})
    @ConditionalOnBean(name={"dw-mq"})
    public DWMqStartupEvent mqStartupEvent(DWMq mq, ApplicationArguments applicationArguments) {
        return new DWMqStartupEvent(mq, applicationArguments);
    }

    @Bean(name={"on-load-methods-startup"})
    public OnLoadMethodsStartupEvent onLoadMethodsStartupEvent(DWContainerContext containerContext, ApplicationArguments applicationArguments) {
        return new OnLoadMethodsStartupEvent(containerContext, applicationArguments);
    }

    @Bean(name={"application-startup"})
    public ApplicationStartup applicationStartup(List<CommandLineRunner> runners) {
        return new ApplicationStartup(runners);
    }

    @Bean(name={"dw-eai-service-instance-start-up"})
    @Conditional(value={DWEAIServiceInstanceCondition.class})
    public ServiceInstanceStartUpEvent eaiServiceInstanceStartUpEvent(ServiceInstanceService dwEaiServiceInstanceService, ApplicationArguments applicationArguments) {
        return new ServiceInstanceStartUpEvent(dwEaiServiceInstanceService, applicationArguments);
    }

    @Bean(name={"dw-eai-service-fasynctask-compensation-start-up"})
    @Conditional(value={DWEAIServiceInstanceCondition.class})
    public CompensationStartUpEvent eaiServiceFasynctaskCompensationStartUpEvent(CompensationService dwEaiServiceFasynctaskCompensationService, ApplicationArguments applicationArguments) {
        return new CompensationStartUpEvent(dwEaiServiceFasynctaskCompensationService, applicationArguments);
    }

    public void destroy() throws Exception {
        DWModuleSpringUtils.stop();
    }
}

