/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.fuse;

import com.digiwin.app.eai.DWEAIFuseProperties;
import com.digiwin.gateway.fuse.config.DapPropertiesOptionKey;
import com.digiwin.gateway.fuse.execute.DWFuseOption;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@Configuration
public class DWFuseAutoConfiguration {
    public DWFuseAutoConfiguration(Environment environment) {
        String httpClientConnectionsMaxIdleTimeString = environment.getProperty("dap.fuse.http-client.connection-max-idle-time");
        if (httpClientConnectionsMaxIdleTimeString != null && !httpClientConnectionsMaxIdleTimeString.isEmpty()) {
            DWEAIFuseProperties.setHttpClientConnectionMaxIdleTime((long)Long.parseLong(httpClientConnectionsMaxIdleTimeString));
        }
    }

    @Bean(value={"dw-fuse-default-option"})
    @DependsOn(value={"dw-spring-context-utils"})
    public DWFuseOption getDefaultOption(Environment environment) {
        String isIgnoreUnassignedXRateLimitHeaderKey = DapPropertiesOptionKey.isIgnoreUnassignedXRateLimitHeader();
        String isXRateLimitHeaderOnKey = DapPropertiesOptionKey.isXRateLimitHeaderOn();
        String isCollectMetricsKey = DapPropertiesOptionKey.isCollectMetrics();
        String isAutoFuseHttpStatusCodeKey = DapPropertiesOptionKey.isAutoFuseHttpStatusCode();
        String inboundErrorHttpStatusCodeKey = DapPropertiesOptionKey.inboundErrorHttpStatusCode();
        String outboundErrorHttpStatusCodeKey = DapPropertiesOptionKey.outboundErrorHttpStatusCode();
        String isIgnoreUnassignedXRateLimitHeader = environment.getProperty(isIgnoreUnassignedXRateLimitHeaderKey, String.valueOf(true));
        String isXRateLimitHeaderOn = environment.getProperty(isXRateLimitHeaderOnKey, String.valueOf(true));
        String isCollectMetrics = environment.getProperty(isCollectMetricsKey, String.valueOf(false));
        String isAutoFuseHttpStatusCode = environment.getProperty(isAutoFuseHttpStatusCodeKey, String.valueOf(true));
        String inboundErrorHttpStatusCode = environment.getProperty(inboundErrorHttpStatusCodeKey, String.valueOf(429));
        String outboundErrorHttpStatusCode = environment.getProperty(outboundErrorHttpStatusCodeKey, String.valueOf(503));
        DWFuseOption option = new DWFuseOption();
        option.setIgnoreUnassignedXRateLimitHeader(isIgnoreUnassignedXRateLimitHeader);
        option.setXRateLimitHeaderOn(isXRateLimitHeaderOn);
        option.setCollectMetrics(isCollectMetrics);
        option.setAutoFuseHttpStatusCode(isAutoFuseHttpStatusCode);
        option.setInboundErrorHttpStatusCode(inboundErrorHttpStatusCode);
        option.setOutboundErrorHttpStatusCode(outboundErrorHttpStatusCode);
        DWFuseOption.setDefaultOption((DWFuseOption)option);
        return option;
    }
}

