/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.context;

import com.digiwin.app.autoconfigure.UtilitiesAutoConfiguration;
import com.digiwin.app.autoconfigure.condition.DWModularModeCondition;
import com.digiwin.app.autoconfigure.context.DWModularApplicationLayerMessageSourceConfiguration;
import com.digiwin.app.autoconfigure.context.DWModularModuleLayerMessageSourceConfiguration;
import com.digiwin.app.common.DWApplicationSpringUtils;
import com.digiwin.app.module.spring.DWModuleSpringUtils;
import com.digiwin.app.resource.DWApplicationMessageResourceBundleUtils;
import com.digiwin.resource.modular.spring.DWApplicationMessageResourceBundleUtilsMessageSource;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.context.MessageSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.context.MessageSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureBefore(value={MessageSourceAutoConfiguration.class, UtilitiesAutoConfiguration.class})
@Conditional(value={DWModularModeCondition.class})
@ConditionalOnMissingBean(name={"messageSource"}, search=SearchStrategy.CURRENT)
public class DWModularMessageSourceAutoConfiguration {
    public DWModularMessageSourceAutoConfiguration() {
        DWApplicationSpringUtils.registerConfigurationClass(DWModularApplicationLayerMessageSourceConfiguration.class);
        DWModuleSpringUtils.registerModuleBeforeRefreshListener(DWModularMessageSourceAutoConfiguration::beforeModuleApplicationContextRefresh);
    }

    private static void beforeModuleApplicationContextRefresh(String moduleName, GenericXmlApplicationContext applicationContext) {
        AnnotatedGenericBeanDefinition configBeanDef = new AnnotatedGenericBeanDefinition(DWModularModuleLayerMessageSourceConfiguration.class);
        configBeanDef.getConstructorArgumentValues().addGenericArgumentValue((Object)moduleName);
        applicationContext.registerBeanDefinition(configBeanDef.getBeanClassName(), (BeanDefinition)configBeanDef);
    }

    @Bean
    @ConfigurationProperties(prefix="spring.messages")
    public MessageSourceProperties messageSourceProperties() {
        return new MessageSourceProperties();
    }

    @Bean(value={"messageSource"})
    public MessageSource messageSoruce() {
        MessageSourceProperties springMessageSourceProperties = this.messageSourceProperties();
        String[] extraBaseNames = null;
        if (StringUtils.hasText((String)((String)springMessageSourceProperties.getBasename().get(0)))) {
            extraBaseNames = StringUtils.commaDelimitedListToStringArray((String)((String)springMessageSourceProperties.getBasename().get(0)));
            for (int i = 0; i < extraBaseNames.length; ++i) {
                extraBaseNames[i] = extraBaseNames[i].trim();
            }
        }
        DWApplicationMessageResourceBundleUtilsMessageSource messageSource = new DWApplicationMessageResourceBundleUtilsMessageSource(extraBaseNames);
        DWApplicationMessageResourceBundleUtils.setMessageSource((MessageSource)messageSource);
        return messageSource;
    }
}

