/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.merge;

import com.digiwin.app.autoconfigure.DWEAIRestfulUrlRegisterAutoConfiguration;
import com.digiwin.app.autoconfigure.condition.DWMultipleAppEnvironmentCondition;
import com.digiwin.app.autoconfigure.merge.processor.DWSourceAppAwarePropertiesContainerBeanProcessor;
import com.digiwin.app.autoconfigure.merge.processor.DWSourceAppAwarePropertiesWrapperProcessor;
import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.app.eai.merge.DWSourceAppAwareEAIProperties;
import com.digiwin.app.merge.DWAppMergedInfo;
import com.digiwin.app.merge.DWSourceAppAwareUtils;
import com.digiwin.app.merge.DWSourceAppInfo;
import com.digiwin.app.merge.processor.DWSourceAppLoopProcessor;
import com.digiwin.http.client.DWHttpClientProperties;
import com.digiwin.http.client.merge.DWSourceAppAwareHttpClientProperties;
import com.digiwin.iam.DWIAMProperties;
import com.digiwin.iam.IAMHttpRequester;
import com.digiwin.iam.merge.DWSourceAppAwareIAMProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@Conditional(value={DWMultipleAppEnvironmentCondition.class})
public class DWSourceAppAwarePropertiesProviderAutoConfiguration {
    @Bean(name={"dw-source-app-aware-properties-bean-processor"})
    public DWSourceAppAwarePropertiesContainerBeanProcessor propertiesContainerBeanProcessor(ObjectProvider<List<DWSourceAppAwarePropertiesWrapperProcessor>> propertiesWrapperProcessorsProvider) {
        List propertiesWrapperProcessors = (List)propertiesWrapperProcessorsProvider.getIfAvailable(ArrayList::new);
        return new DWSourceAppAwarePropertiesContainerBeanProcessor(propertiesWrapperProcessors);
    }

    @Bean
    public DWEAIRestfulUrlRegisterAutoConfiguration.EaiExtraMappingPathProvider eaiControllerExtraMappingPathProvider(DWEAIProperties dweaiProperties) {
        List extraPaths = null;
        if (dweaiProperties instanceof DWSourceAppAwareEAIProperties) {
            DWAppMergedInfo appMergedInfo = DWSourceAppAwareUtils.getAppMergedInfo();
            ArrayList<DWSourceAppInfo> appList = new ArrayList<DWSourceAppInfo>(appMergedInfo.getSourceAppList());
            appList.add(0, appMergedInfo.getTargetAppInfo());
            DWEAIExtraPathsProcessor processor = new DWEAIExtraPathsProcessor(dweaiProperties);
            Map result = processor.process(appList, appInfo -> appInfo.getAppId());
            extraPaths = IntStream.range(0, 3).mapToObj(i -> (String[])result.values().stream().map(list -> (String)list.get(i)).toArray(String[]::new)).collect(Collectors.toList());
        }
        DWSourceAppAwareEaiExtraMappingPathProvider provider = new DWSourceAppAwareEaiExtraMappingPathProvider((String[])extraPaths.get(0), (String[])extraPaths.get(1), (String[])extraPaths.get(2));
        return provider;
    }

    @Bean
    public DWSourceAppAwarePropertiesWrapperProcessor iamPropertiesWrapperProcessor() {
        return new DWSourceAppAwarePropertiesWrapperProcessor<DWIAMProperties, DWSourceAppAwareIAMProperties>(this){

            public DWSourceAppAwareIAMProperties wrapper(DWIAMProperties bean) throws BeanInitializationException {
                DWSourceAppAwareIAMProperties wrapperProperties = (DWSourceAppAwareIAMProperties)super.wrapper((Object)bean);
                IAMHttpRequester.setProperties((DWIAMProperties)wrapperProperties);
                return wrapperProperties;
            }
        };
    }

    @Bean
    public DWSourceAppAwarePropertiesWrapperProcessor eaiPropertiesWrapperProcessor(final Environment environment) {
        return new DWSourceAppAwarePropertiesWrapperProcessor<DWEAIProperties, DWSourceAppAwareEAIProperties>(this){

            public DWSourceAppAwareEAIProperties wrapper(DWEAIProperties bean) throws BeanInitializationException {
                DWSourceAppAwareEAIProperties wrapperProperties = (DWSourceAppAwareEAIProperties)((Object)super.wrapper((Object)bean));
                wrapperProperties.setEnvironement(environment);
                DWEAIProperties.setProperties((DWEAIProperties)wrapperProperties);
                return wrapperProperties;
            }
        };
    }

    @Bean
    public DWSourceAppAwarePropertiesWrapperProcessor httpClientPropertiesWrapperProcessor() {
        return new DWSourceAppAwarePropertiesWrapperProcessor<DWHttpClientProperties, DWSourceAppAwareHttpClientProperties>(this){

            public DWSourceAppAwareHttpClientProperties wrapper(DWHttpClientProperties bean) throws BeanInitializationException {
                DWSourceAppAwareHttpClientProperties wrapperProperties = (DWSourceAppAwareHttpClientProperties)super.wrapper((Object)bean);
                DWHttpClientProperties.setProperties((DWHttpClientProperties)wrapperProperties);
                return wrapperProperties;
            }
        };
    }

    private static class DWEAIExtraPathsProcessor
    extends DWSourceAppLoopProcessor<DWSourceAppInfo, List<String>>
    implements DWEAIRestfulUrlRegisterAutoConfiguration.EaiExtraMappingPathProvider {
        private DWEAIProperties dweaiProperties;

        DWEAIExtraPathsProcessor(DWEAIProperties dweaiProperties) {
            this.dweaiProperties = dweaiProperties;
        }

        public List<String> unitProcess(String appId, List data) {
            ArrayList<String> pathList = new ArrayList<String>();
            pathList.add(this.dweaiProperties.getRestfulServicePath());
            pathList.add(this.dweaiProperties.getRestfulServiceCallbackPath());
            pathList.add(this.dweaiProperties.getRestfulServiceSyncProdPath());
            return pathList;
        }

        public void summary(Map<String, List<String>> processHistory) {
        }

        @Override
        public String[] getExtraEaiPaths() {
            return new String[0];
        }

        @Override
        public String[] getExtraEaiCallbackPaths() {
            return new String[0];
        }

        @Override
        public String[] getExtraSyncProdPaths() {
            return new String[0];
        }
    }

    public static class DWSourceAppAwareEaiExtraMappingPathProvider
    implements DWEAIRestfulUrlRegisterAutoConfiguration.EaiExtraMappingPathProvider {
        private String[] extraEaiPaths;
        private String[] extraEaiCallbackPaths;
        private String[] extraSyncProdPaths;

        private DWSourceAppAwareEaiExtraMappingPathProvider(String[] extraEaiPaths, String[] extraEaiCallbackPaths, String[] extraSyncProdPaths) {
            this.extraEaiPaths = extraEaiPaths;
            this.extraEaiCallbackPaths = extraEaiCallbackPaths;
            this.extraSyncProdPaths = extraSyncProdPaths;
        }

        @Override
        public String[] getExtraEaiPaths() {
            return this.extraEaiPaths;
        }

        @Override
        public String[] getExtraEaiCallbackPaths() {
            return this.extraEaiCallbackPaths;
        }

        @Override
        public String[] getExtraSyncProdPaths() {
            return this.extraSyncProdPaths;
        }
    }
}

