/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.local.mock.rap;

import com.digiwin.app.container.local.mock.DWMockData;
import com.digiwin.app.container.local.mock.DWMockHeader;
import com.digiwin.app.container.local.mock.DWMockMethod;
import com.digiwin.app.container.local.mock.DWMockParameter;
import com.digiwin.app.container.local.mock.rap.DWRapMockInfoProvider;
import com.digiwin.app.container.local.mock.rap.DWRapMockMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWFalconRapMockInfoProvider
extends DWRapMockInfoProvider {
    private static Log log = LogFactory.getLog(DWFalconRapMockInfoProvider.class);

    @Override
    protected DWMockHeader[] getMockHeadersCore(List<Map<String, Object>> rapModuleList) throws Exception {
        HashMap<String, List<DWMockMethod>> moduleServiceMethodList;
        String moduleName;
        HashMap<String, HashMap<String, List<DWMockMethod>>> modulesMethodList = new HashMap<String, HashMap<String, List<DWMockMethod>>>();
        for (Map<String, Object> moduleItem : rapModuleList) {
            moduleName = moduleItem.get("name").toString();
            log.debug((Object)(">>> RAP Mock Provider Found Module -> " + moduleName));
            moduleServiceMethodList = (Map)modulesMethodList.get(moduleName);
            if (moduleServiceMethodList == null) {
                moduleServiceMethodList = new HashMap<String, List<DWMockMethod>>();
                modulesMethodList.put(moduleName, moduleServiceMethodList);
            }
            this.buildRapModuleDWMockMethods(moduleItem, moduleServiceMethodList);
        }
        ArrayList<DWMockHeader> mockHeaders = new ArrayList<DWMockHeader>();
        for (Map.Entry mapItem : modulesMethodList.entrySet()) {
            moduleName = (String)mapItem.getKey();
            moduleServiceMethodList = (HashMap<String, List<DWMockMethod>>)mapItem.getValue();
            for (Map.Entry serviceMapItem : moduleServiceMethodList.entrySet()) {
                String serviceName = (String)serviceMapItem.getKey();
                DWMockHeader moduleMockHeader = new DWMockHeader(moduleName, serviceName, (List)serviceMapItem.getValue());
                mockHeaders.add(moduleMockHeader);
            }
        }
        DWMockHeader[] headerArray = new DWMockHeader[mockHeaders.size()];
        headerArray = mockHeaders.toArray(headerArray);
        return headerArray;
    }

    private void buildRapModuleDWMockMethods(Map<String, Object> rapModuleItem, Map<String, List<DWMockMethod>> serviceMockMethods) {
        List pageList = (List)rapModuleItem.get("pageList");
        for (Map pageItem : pageList) {
            String serviceName = pageItem.get("name").toString();
            log.debug((Object)(">>>... Found Service -> " + serviceName));
            List<DWMockMethod> serviceMethods = serviceMockMethods.get(serviceName);
            if (serviceMethods == null) {
                serviceMethods = new ArrayList<DWMockMethod>();
                serviceMockMethods.put(serviceName, serviceMethods);
            }
            this.buildRapServiceDWMockMethods(pageItem, serviceMethods);
        }
    }

    private void buildRapServiceDWMockMethods(Map<String, Object> rapPageItem, List<DWMockMethod> serviceMockMethodList) {
        List actionList = (List)rapPageItem.get("actionList");
        for (Map actionItem : actionList) {
            String methodName = actionItem.get("name").toString();
            log.debug((Object)(">>>...... Found Method -> " + methodName));
            this.buildSingleMockMethod(actionItem, serviceMockMethodList);
        }
    }

    private void buildSingleMockMethod(Map<String, Object> rapActionItem, List<DWMockMethod> serviceMockMethodList) {
        DWMockMethod newMockMethod = this.createDWMockMethod(rapActionItem);
        boolean matched = false;
        Map<String, Class<?>> newMockMethodParameterInfo = newMockMethod.getParameterInfo();
        for (DWMockMethod methodItem : serviceMockMethodList) {
            if (methodItem.getMethodName() != newMockMethod.getMethodName() || methodItem.getParameterInfo().size() != newMockMethodParameterInfo.size()) continue;
            for (Map.Entry<String, Class<?>> parameter : methodItem.getParameterInfo().entrySet()) {
                String parameterName = parameter.getKey();
                Class<?> parameterType = parameter.getValue();
                if (!newMockMethodParameterInfo.containsKey(parameterName) || parameterType != newMockMethodParameterInfo.get(parameterName)) break;
                matched = true;
            }
            if (!matched) continue;
            methodItem.addAllMockDatas(newMockMethod.getMockDatas());
            log.debug((Object)">>>...... Method is Exist, add new mock data to the exist one.");
            log.debug((Object)(">>>......... new method info = " + methodItem.toString()));
            break;
        }
        if (!matched) {
            serviceMockMethodList.add(newMockMethod);
            log.debug((Object)(">>>...... Mock method info = " + newMockMethod.toString()));
        }
    }

    private DWMockMethod createDWMockMethod(Map<String, Object> rapActionItem) {
        ArrayList<DWMockParameter> parameters = new ArrayList<DWMockParameter>();
        HashMap<Integer, Map<String, Object>> mockInputGroups = new HashMap<Integer, Map<String, Object>>();
        HashMap<Integer, Object> mockOutputGroups = new HashMap<Integer, Object>();
        List rawParameterList = (List)rapActionItem.get("requestParameterList");
        for (Map rawParameter : rawParameterList) {
            String parameterName = rawParameter.get("identifier").toString();
            String typeString = rawParameter.get("dataType").toString();
            Class<?> parameterType = this.getParameterType(typeString);
            DWMockParameter mockParameter = new DWMockParameter(parameterName, parameterType);
            parameters.add(mockParameter);
            this.buildDWMockInputGroup(rawParameter, mockInputGroups);
        }
        this.buildDWMockOutputGroup(rapActionItem, mockOutputGroups);
        List<DWMockData> mockDatas = this.createMockDataList(mockInputGroups, mockOutputGroups);
        String requestUrl = rapActionItem.get("requestUrl").toString();
        String targetMethodName = rapActionItem.get("name").toString();
        DWRapMockMethod mockMethod = new DWRapMockMethod(this.mockServiceExecuteMethod, targetMethodName, targetMethodName, requestUrl, parameters);
        mockMethod.setMockDataProvider(this);
        mockMethod.addAllMockDatas(mockDatas);
        return mockMethod;
    }

    private List<DWMockData> createMockDataList(Map<Integer, Map<String, Object>> mockInputGroups, Map<Integer, Object> mockOutputGroups) {
        DWMockData mockData;
        ArrayList<DWMockData> mockDataList = new ArrayList<DWMockData>();
        for (Map.Entry<Integer, Map<String, Object>> inputGroup : mockInputGroups.entrySet()) {
            Integer index = inputGroup.getKey();
            Map<String, Object> inputValue = inputGroup.getValue();
            Object outputValue = mockOutputGroups.remove(index);
            mockData = new DWMockData(inputValue, outputValue);
            mockDataList.add(mockData);
        }
        for (Object notMatchedOutput : mockOutputGroups.values()) {
            mockData = new DWMockData(null, notMatchedOutput);
            mockDataList.add(mockData);
        }
        return mockDataList;
    }

    private void buildDWMockInputGroup(Map<String, Object> rapInputParameter, Map<Integer, Map<String, Object>> mockInputGroups) {
        String parameterName = rapInputParameter.get("identifier").toString();
        int groupIndex = 0;
        Map<String, Object> inputGroup = mockInputGroups.get(groupIndex);
        if (inputGroup == null) {
            inputGroup = new HashMap<String, Object>();
            mockInputGroups.put(groupIndex, inputGroup);
        }
        inputGroup.put(parameterName, null);
    }

    private void buildDWMockOutputGroup(Map<String, Object> rapActionItem, Map<Integer, Object> mockOutputGroups) {
        int groupIndex = 0;
        Object outputValue = null;
        try {
            String requestUrl = rapActionItem.get("requestUrl").toString();
            outputValue = this.getRealTimeMockDataObject(requestUrl);
        }
        catch (Exception e) {
            log.error((Object)"DWRapMockInfoProvider.buildDWMockOutputGroup failed!", (Throwable)e);
        }
        mockOutputGroups.put(groupIndex, outputValue);
    }
}

