/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.local.mock;

import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.local.mock.DWMockData;
import com.digiwin.app.container.local.mock.DWMockParameter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DWMockMethod
extends DWMethod {
    private List<DWMockData> _mockDatas = new ArrayList<DWMockData>();
    private List<DWMockParameter> _parameters;
    private String _mockTargetMethodName;
    private String _mockInfo;
    private String _requestUrl;

    public DWMockMethod(Method method, String mockTargetMethodName, String requestUrl, List<DWMockParameter> parameters) {
        super(method);
        if (mockTargetMethodName == null || mockTargetMethodName.isEmpty()) {
            throw new IllegalArgumentException("mockTargetMethodName is null!");
        }
        this._mockTargetMethodName = mockTargetMethodName;
        this._requestUrl = requestUrl;
        this._parameters = parameters == null ? Collections.emptyList() : parameters;
    }

    public void setMockInfo(String mockInfo) {
        this._mockInfo = mockInfo;
    }

    public String getMockInfo() {
        return this._mockInfo;
    }

    public void addMockData(DWMockData mockData) {
        this._mockDatas.add(mockData);
    }

    public void addAllMockDatas(Collection<DWMockData> mockDatas) {
        this._mockDatas.addAll(mockDatas);
    }

    public List<DWMockData> getMockDatas() {
        return Collections.unmodifiableList(this._mockDatas);
    }

    public String getMethodName() {
        return this._mockTargetMethodName;
    }

    public boolean allowAnonymous() {
        return false;
    }

    public String getMockUrl() {
        return this._requestUrl;
    }

    public Map<String, Class<?>> getParameterInfo() {
        LinkedHashMap info = new LinkedHashMap();
        for (DWMockParameter parameter : this._parameters) {
            info.put(parameter.getName(), parameter.getValueType());
        }
        return info;
    }

    public boolean isMatch(DWParameters parameters) {
        String[] parameterNames;
        if (parameters == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (DWMockParameter item : this._parameters) {
            nameList.add(item.getName());
        }
        if (this._parameters.size() != parameters.getCount().intValue()) {
            return false;
        }
        for (String name : parameterNames = parameters.getNames()) {
            if (!nameList.contains(name)) {
                return false;
            }
            nameList.remove(name);
        }
        return true;
    }

    public Object invoke(Object service, DWParameters parameters) throws Exception {
        if (this._mockDatas.size() > 0) {
            return this._mockDatas.get(0).getOutput();
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Url(").append(this._requestUrl).append("), ");
        result.append("Signature(");
        ArrayList<String> parameterInfos = new ArrayList<String>();
        for (DWMockParameter mockParameter : this._parameters) {
            parameterInfos.add(mockParameter.toString());
        }
        result.append(String.join((CharSequence)", ", parameterInfos));
        result.append(")");
        result.append(", mock datas=(");
        int i = 1;
        for (DWMockData mockData : this._mockDatas) {
            result.append("[");
            result.append(i++).append(".").append(mockData.toString());
            result.append("]");
        }
        result.append(")");
        return result.toString();
    }
}

