/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.local.mock.rap;

import com.digiwin.app.container.local.mock.DWMockData;
import com.digiwin.app.container.local.mock.DWMockHeader;
import com.digiwin.app.container.local.mock.DWMockMethod;
import com.digiwin.app.container.local.mock.DWMockParameter;
import com.digiwin.app.container.local.mock.rap.DWRapMockInfoProvider;
import com.digiwin.app.container.local.mock.rap.DWRapMockMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWStandardRapMockInfoProvider
extends DWRapMockInfoProvider {
    private static Log log = LogFactory.getLog(DWStandardRapMockInfoProvider.class);

    @Override
    protected DWMockHeader[] getMockHeadersCore(List<Map<String, Object>> rapModuleList) throws Exception {
        String moduleName;
        HashMap<String, Map<String, List<DWMockMethod>>> modulesMethodList = new HashMap<String, Map<String, List<DWMockMethod>>>();
        for (Map<String, Object> moduleItem : rapModuleList) {
            moduleName = moduleItem.get("name").toString();
            log.debug((Object)(">>> RAP Mock Provider, Found RAP Module -> " + moduleName));
            this.buildRapModuleDWMockMethods(moduleItem, modulesMethodList);
        }
        ArrayList<DWMockHeader> mockHeaders = new ArrayList<DWMockHeader>();
        for (Map.Entry mapItem : modulesMethodList.entrySet()) {
            moduleName = (String)mapItem.getKey();
            Map moduleServiceMethodList = (Map)mapItem.getValue();
            for (Map.Entry serviceMapItem : moduleServiceMethodList.entrySet()) {
                String serviceName = (String)serviceMapItem.getKey();
                DWMockHeader moduleMockHeader = new DWMockHeader(moduleName, serviceName, (List)serviceMapItem.getValue());
                mockHeaders.add(moduleMockHeader);
            }
        }
        DWMockHeader[] headerArray = new DWMockHeader[mockHeaders.size()];
        headerArray = mockHeaders.toArray(headerArray);
        return headerArray;
    }

    private void buildRapModuleDWMockMethods(Map<String, Object> rapModuleItem, Map<String, Map<String, List<DWMockMethod>>> modulesMethodList) {
        List pageList = (List)rapModuleItem.get("pageList");
        for (Map pageItem : pageList) {
            String pageName = pageItem.get("name").toString();
            log.debug((Object)(">>>... Found RAP Page -> " + pageName));
            this.buildRapServiceDWMockMethods(pageItem, modulesMethodList);
        }
    }

    private void buildRapServiceDWMockMethods(Map<String, Object> rapPageItem, Map<String, Map<String, List<DWMockMethod>>> modulesMethodList) {
        List actionList = (List)rapPageItem.get("actionList");
        for (Map actionItem : actionList) {
            String actionName = actionItem.get("name").toString();
            log.debug((Object)(">>>...... Found RAP Action -> " + actionName));
            this.buildSingleMockMethod(actionItem, modulesMethodList);
        }
    }

    private void buildSingleMockMethod(Map<String, Object> rapActionItem, Map<String, Map<String, List<DWMockMethod>>> modulesMethodList) {
        List<DWMockMethod> serviceMockMethodList;
        RapMockMethodCreateInfo createInfo = this.createDWMockMethod(rapActionItem);
        if (createInfo == null) {
            return;
        }
        DWMockMethod newMockMethod = createInfo.mockMethod;
        String moduleName = createInfo.moduleName;
        String serviceName = createInfo.serviceName;
        Map<String, List<DWMockMethod>> singleModuleMethodList = modulesMethodList.get(moduleName);
        if (singleModuleMethodList == null) {
            singleModuleMethodList = new HashMap<String, List<DWMockMethod>>();
            modulesMethodList.put(moduleName, singleModuleMethodList);
        }
        if ((serviceMockMethodList = singleModuleMethodList.get(serviceName)) == null) {
            serviceMockMethodList = new ArrayList<DWMockMethod>();
            singleModuleMethodList.put(serviceName, serviceMockMethodList);
        }
        boolean matched = false;
        Map<String, Class<?>> newMockMethodParameterInfo = newMockMethod.getParameterInfo();
        for (DWMockMethod methodItem : serviceMockMethodList) {
            if (methodItem.getMethodName() != newMockMethod.getMethodName() || methodItem.getParameterInfo().size() != newMockMethodParameterInfo.size()) continue;
            for (Map.Entry<String, Class<?>> parameter : methodItem.getParameterInfo().entrySet()) {
                String parameterName = parameter.getKey();
                Class<?> parameterType = parameter.getValue();
                if (!newMockMethodParameterInfo.containsKey(parameterName) || parameterType != newMockMethodParameterInfo.get(parameterName)) break;
                matched = true;
            }
            if (!matched) continue;
            methodItem.addAllMockDatas(newMockMethod.getMockDatas());
            log.debug((Object)">>>...... Method is Exist, add new mock data to the exist one.");
            log.debug((Object)(">>>......... new method info = " + methodItem.toString()));
            break;
        }
        if (!matched) {
            serviceMockMethodList.add(newMockMethod);
            log.debug((Object)(">>>...... Mock method info = " + newMockMethod.toString()));
        }
    }

    private RapMockMethodCreateInfo createDWMockMethod(Map<String, Object> rapActionItem) {
        ArrayList<DWMockParameter> parameters = new ArrayList<DWMockParameter>();
        HashMap<Integer, Map<String, Object>> mockInputGroups = new HashMap<Integer, Map<String, Object>>();
        HashMap<Integer, Object> mockOutputGroups = new HashMap<Integer, Object>();
        List rawParameterList = (List)rapActionItem.get("requestParameterList");
        for (Map rawParameter : rawParameterList) {
            String parameterName = rawParameter.get("identifier").toString();
            if (parameterName.contains("|")) {
                String[] specialParameterParts = parameterName.split("|");
                parameterName = specialParameterParts[0];
            }
            String typeString = rawParameter.get("dataType").toString();
            Class<?> parameterType = this.getParameterType(typeString);
            DWMockParameter mockParameter = new DWMockParameter(parameterName, parameterType);
            parameters.add(mockParameter);
            this.buildDWMockInputGroup(rawParameter, mockInputGroups);
        }
        RapMockMethodCreateInfo createInfo = this.createRapMockMethodCreateInfo(rapActionItem, parameters);
        if (createInfo != null) {
            this.buildDWMockOutputGroup(rapActionItem, mockOutputGroups);
            List<DWMockData> mockDatas = this.createMockDataList(mockInputGroups, mockOutputGroups);
            createInfo.mockMethod.addAllMockDatas(mockDatas);
        }
        return createInfo;
    }

    private RapMockMethodCreateInfo createRapMockMethodCreateInfo(Map<String, Object> rapActionItem, List<DWMockParameter> parameters) {
        String requestUrl = rapActionItem.get("requestUrl").toString();
        log.debug((Object)(">>>......... requestUrl = " + requestUrl));
        String[] parts = null;
        if (requestUrl == null) {
            log.error((Object)">>>......... requestUrl is null, Stop Creating Mock Method!");
            return null;
        }
        parts = requestUrl.split("/");
        if (parts.length != 3) {
            log.error((Object)">>>......... requestUrl format is not right, Stop Creating Mock Method!");
            log.debug((Object)">>>......... the format should be like -> [module name]/[service name]/[method name]");
            return null;
        }
        String moduleName = parts[0].trim();
        String serviceName = parts[1].trim();
        String targetMethodName = parts[2].trim();
        if (moduleName.length() == 0) {
            log.error((Object)">>>......... module name is empty, Stop Creating Mock Method!");
            return null;
        }
        if (serviceName.length() == 0) {
            log.error((Object)">>>......... service name is empty, Stop Creating Mock Method!");
            return null;
        }
        if (targetMethodName.length() == 0) {
            log.error((Object)">>>......... method name is empty, Stop Creating Mock Method!");
            return null;
        }
        String rapActionItemName = (String)rapActionItem.get("name");
        DWRapMockMethod mockMethod = new DWRapMockMethod(this.mockServiceExecuteMethod, rapActionItemName, targetMethodName, requestUrl, parameters);
        mockMethod.setMockDataProvider(this);
        log.info((Object)("create mock method -> " + moduleName + "." + serviceName + "." + targetMethodName));
        return new RapMockMethodCreateInfo(moduleName, serviceName, mockMethod);
    }

    private List<DWMockData> createMockDataList(Map<Integer, Map<String, Object>> mockInputGroups, Map<Integer, Object> mockOutputGroups) {
        DWMockData mockData;
        ArrayList<DWMockData> mockDataList = new ArrayList<DWMockData>();
        for (Map.Entry<Integer, Map<String, Object>> inputGroup : mockInputGroups.entrySet()) {
            Integer index = inputGroup.getKey();
            Map<String, Object> inputValue = inputGroup.getValue();
            Object outputValue = mockOutputGroups.remove(index);
            mockData = new DWMockData(inputValue, outputValue);
            mockDataList.add(mockData);
        }
        for (Object notMatchedOutput : mockOutputGroups.values()) {
            mockData = new DWMockData(null, notMatchedOutput);
            mockDataList.add(mockData);
        }
        return mockDataList;
    }

    private void buildDWMockInputGroup(Map<String, Object> rapInputParameter, Map<Integer, Map<String, Object>> mockInputGroups) {
        String parameterName = rapInputParameter.get("identifier").toString();
        int groupIndex = 0;
        Map<String, Object> inputGroup = mockInputGroups.get(groupIndex);
        if (inputGroup == null) {
            inputGroup = new HashMap<String, Object>();
            mockInputGroups.put(groupIndex, inputGroup);
        }
        inputGroup.put(parameterName, null);
    }

    private void buildDWMockOutputGroup(Map<String, Object> rapActionItem, Map<Integer, Object> mockOutputGroups) {
        int groupIndex = 0;
        Object outputValue = null;
        try {
            String requestUrl = rapActionItem.get("requestUrl").toString();
            outputValue = this.getRealTimeMockDataObject(requestUrl);
        }
        catch (Exception e) {
            log.error((Object)"DWRapMockInfoProvider.buildDWMockOutputGroup failed!", (Throwable)e);
        }
        mockOutputGroups.put(groupIndex, outputValue);
    }

    private class RapMockMethodCreateInfo {
        private String moduleName;
        private String serviceName;
        private DWMockMethod mockMethod;

        public RapMockMethodCreateInfo(String moduleName, String serviceName, DWMockMethod mockMethod) {
            this.moduleName = moduleName;
            this.serviceName = serviceName;
            this.mockMethod = mockMethod;
        }
    }
}

