/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.local;

import com.digiwin.app.container.DWAbstractHeaderRepository;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWMethodMatchProcessor;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.service.DWServiceLocationInfo;
import com.digiwin.app.service.DWSimpleServiceLocationInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DWLocalHeaderRepository
extends DWAbstractHeaderRepository<DWHeader, DWSimpleServiceLocationInfo> {
    private Map<DWHeader, Map<String, List<DWMethod>>> _methodMap = new HashMap<DWHeader, Map<String, List<DWMethod>>>();

    protected void afterRegister(String groupName, List<DWHeader> headers, List<DWHeader> oldHeaders) {
        this.createMethodMap(groupName, headers);
    }

    private void createMethodMap(String groupName, List<DWHeader> headers) {
        this._methodMap.entrySet().removeIf(item -> groupName.equals(((DWHeader)item.getKey()).getModuleName()));
        headers.forEach(header -> this._methodMap.put((DWHeader)header, header.getDWMethods()));
    }

    protected DWTargetAPI searchAPI(DWSimpleServiceLocationInfo locationInfo) {
        DWHeader header = this.getHeaders(locationInfo.getGroup()).stream().filter(h -> h.getServiceName().equals(locationInfo.getServiceName())).findFirst().orElse(null);
        if (header == null) {
            return DWTargetAPI.createInvalidAPI();
        }
        DWMethod method = null;
        Map<String, List<DWMethod>> methodMap = this._methodMap.get(header);
        if (methodMap != null) {
            for (DWMethodMatchProcessor matchProcessor : this._matchProcessors) {
                matchProcessor.process(methodMap, (DWServiceLocationInfo)locationInfo);
                List<DWMethod> methodList = methodMap.get(locationInfo.getMethodName());
                if (methodList == null || (method = (DWMethod)methodList.stream().filter(m -> m.isMatch(locationInfo.getParameters())).findFirst().orElse(null)) == null) continue;
                break;
            }
        }
        return new DWTargetAPI(header, method);
    }
}

