/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.exceptions.DWMethodNotFoundException;
import com.digiwin.app.container.exceptions.DWServiceNotFoundException;
import com.digiwin.app.module.DWModuleInfoProvider;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.DWService;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public class DWCrossModuleServiceInvoker {
    public static Object invoke(Object sourceDao, String moduleName, String serviceName, String methodName, DWDefaultParameters parameters) throws Exception {
        Object result = null;
        DWServiceInfo serviceInfo = DWCrossModuleServiceInvoker.getOtherModuleServiceInfo(moduleName, serviceName);
        if (serviceInfo == null) {
            throw new DWServiceNotFoundException(moduleName, serviceName);
        }
        DWService serviceInstance = serviceInfo.getInstance();
        Class implementType = serviceInfo.getImplementationType();
        boolean isMockService = false;
        if (implementType.isAssignableFrom(serviceInstance.getClass())) {
            parameters.put("targetDao", sourceDao);
        } else {
            isMockService = true;
            implementType = serviceInfo.getInterfaceType();
        }
        DWMethod targetMethod = DWCrossModuleServiceInvoker.getServiceTargetMethod(implementType, serviceInstance, methodName, parameters);
        if (targetMethod == null) {
            throw new DWMethodNotFoundException(moduleName, serviceName, methodName, parameters);
        }
        result = targetMethod.invoke(serviceInstance, parameters);
        if (isMockService) {
            throw new Exception("Mock Service is not correct, throw exception must be executed!");
        }
        return result;
    }

    private static DWServiceInfo getOtherModuleServiceInfo(String moduleName, String serviceName) throws Exception {
        Map serviceInfoMap = DWModuleInfoProvider.getImplementationInfos();
        List serviceList = (List)serviceInfoMap.get(moduleName);
        DWServiceInfo serviceInfo = null;
        for (DWServiceInfo item : serviceList) {
            if (!item.getInterfaceType().getSimpleName().equals(serviceName)) continue;
            serviceInfo = item;
            break;
        }
        return serviceInfo;
    }

    private static DWMethod getServiceTargetMethod(Class<?> implementType, Object serviceInstance, String methodName, DWParameters parameters) {
        Method[] methodList = implementType.getMethods();
        if (methodList == null) {
            throw new IllegalStateException();
        }
        DWMethod methodInfo = null;
        for (Method method : methodList) {
            if (!methodName.equals(method.getName())) continue;
            methodInfo = new DWMethod(method);
            if (methodInfo.isMatch(parameters)) break;
            methodInfo = null;
        }
        return methodInfo;
    }
}

