/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.common.DWApplicationSpringUtils;
import com.digiwin.app.container.AnnotaionUtils;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.ServiceFuse;
import com.digiwin.app.container.exceptions.DWParameterCastException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.gateway.fuse.DWFuseExecutor;
import com.digiwin.gateway.fuse.DWReturnFuse;
import com.digiwin.gateway.fuse.annotation.FuseInbound;
import com.digiwin.gateway.fuse.annotation.FuseOutbound;
import com.digiwin.gateway.fuse.config.DapPropertiesInboundKey;
import com.digiwin.gateway.fuse.config.DapPropertiesOptionKey;
import com.digiwin.gateway.fuse.config.DapPropertiesOutboundKey;
import com.digiwin.gateway.fuse.config.InboundConfig;
import com.digiwin.gateway.fuse.config.InboundConfigBuilder;
import com.digiwin.gateway.fuse.config.OutboundConfig;
import com.digiwin.gateway.fuse.config.OutboundConfigBuilder;
import com.digiwin.gateway.fuse.execute.DWFuseOption;
import com.digiwin.gateway.fuse.execute.DWFuseParameter;
import com.digiwin.gateway.fuse.execute.DWFuseReturnResponse;
import io.prometheus.client.CollectorRegistry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class DWMethod {
    private static Log log = LogFactory.getLog(DWMethod.class);
    private Method _method = null;
    protected Boolean _allowAnonymous = null;
    protected Annotation[] _methodAnnotations = null;

    public DWMethod(Method method) {
        if (method == null) {
            throw new IllegalArgumentException();
        }
        this._method = method;
    }

    public Method getMethod() {
        return this._method;
    }

    public String getMethodName() {
        return this._method.getName();
    }

    public boolean allowAnonymous() {
        if (this._allowAnonymous == null) {
            this._allowAnonymous = this._method.isAnnotationPresent(AllowAnonymous.class);
        }
        return this._allowAnonymous;
    }

    public boolean isMatch(DWParameters parameters) {
        return DWMethod.isMatch(this._method, parameters);
    }

    public static boolean isMatch(Method method, DWParameters parameters) {
        String[] parameterNames;
        if (parameters == null) {
            throw new IllegalArgumentException();
        }
        Parameter[] parameterList = method.getParameters();
        if (parameterList == null) {
            throw new IllegalStateException();
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (Parameter item : parameterList) {
            nameList.add(item.getName());
        }
        if (parameterList.length != parameters.getCount()) {
            return false;
        }
        for (String name : parameterNames = parameters.getNames()) {
            if (!nameList.contains(name)) {
                return false;
            }
            nameList.remove(name);
        }
        return true;
    }

    public Object invoke(Object service, DWParameters parameters) throws Exception {
        if (service == null) {
            throw new IllegalArgumentException();
        }
        if (parameters == null) {
            throw new IllegalArgumentException();
        }
        Parameter[] parameterList = this._method.getParameters();
        if (parameterList == null) {
            throw new IllegalStateException();
        }
        Object[] invokeParameterList = new Object[parameterList.length];
        for (int i = 0; i < parameterList.length; ++i) {
            Object invokeParameter = null;
            try {
                invokeParameter = parameters.getValue(parameterList[i]);
            }
            catch (Exception ex) {
                throw new DWParameterCastException(parameterList[i].getName(), parameterList[i].getType(), ex);
            }
            invokeParameterList[i] = invokeParameter;
        }
        this._methodAnnotations = this._method.getDeclaredAnnotations();
        if (!this._method.getName().equals("getModuleInfos")) {
            HashMap<String, Object> annotaionMap = new HashMap<String, Object>();
            annotaionMap.put("methodAnnotations", this._methodAnnotations);
            AnnotaionUtils.setAnnotation(annotaionMap);
        }
        InboundConfig inboundConfig = null;
        OutboundConfig outboundConfig = null;
        CollectorRegistry collectorRegistry = null;
        try {
            ApplicationContext applicationContext = DWApplicationSpringUtils.getContext();
            collectorRegistry = (CollectorRegistry)applicationContext.getBean(CollectorRegistry.class);
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            String stackTrace = stringWriter.toString();
            log.debug((Object)("[DWMethod] collectorRegistry: " + e.getMessage()));
            log.debug((Object)("[DWMethod] stackTrace: " + stackTrace));
        }
        if (this._method.isAnnotationPresent(FuseInbound.class)) {
            FuseInbound fuseInbound = this._method.getAnnotation(FuseInbound.class);
            inboundConfig = this.getInboundConfig(fuseInbound);
            inboundConfig.setCollectorRegistry(collectorRegistry);
        }
        if (this._method.isAnnotationPresent(FuseOutbound.class)) {
            FuseOutbound fuseOutbound = this._method.getAnnotation(FuseOutbound.class);
            outboundConfig = this.getOutboundConfig(fuseOutbound);
            outboundConfig.setCollectorRegistry(collectorRegistry);
        }
        ServiceFuse serviceFuse = new ServiceFuse();
        DWFuseParameter fuseParameter = new DWFuseParameter();
        fuseParameter.set("method", (Object)this._method);
        fuseParameter.set("service", service);
        fuseParameter.set("invokeParameterList", (Object)invokeParameterList);
        DWFuseReturnResponse fuseReturnResponse = new DWFuseReturnResponse();
        DWFuseOption option = this.getOption();
        option.setAutoFuseHttpStatusCode(false);
        log.debug((Object)("[DWMethod] option: " + option));
        fuseReturnResponse = DWFuseExecutor.execute((DWReturnFuse)serviceFuse, (DWFuseParameter)fuseParameter, (InboundConfig)inboundConfig, (OutboundConfig)outboundConfig, (DWFuseOption)option);
        Object result = fuseReturnResponse.getResponse();
        return result;
    }

    public Map<String, Class<?>> getParameterInfo() {
        Parameter[] parameters;
        LinkedHashMap parameterInfo = new LinkedHashMap();
        for (Parameter parameter : parameters = this._method.getParameters()) {
            parameterInfo.put(parameter.getName(), parameter.getType());
        }
        return parameterInfo;
    }

    private DWFuseOption getOption() {
        String isIgnoreUnassignedXRateLimitHeaderKey = DapPropertiesOptionKey.isIgnoreUnassignedXRateLimitHeader();
        String isXRateLimitHeaderOnKey = DapPropertiesOptionKey.isXRateLimitHeaderOn();
        String isCollectMetricsKey = DapPropertiesOptionKey.isCollectMetrics();
        String isAutoFuseHttpStatusCodeKey = DapPropertiesOptionKey.isAutoFuseHttpStatusCode();
        String inboundErrorHttpStatusCodeKey = DapPropertiesOptionKey.inboundErrorHttpStatusCode();
        String outboundErrorHttpStatusCodeKey = DapPropertiesOptionKey.outboundErrorHttpStatusCode();
        String isIgnoreUnassignedXRateLimitHeader = DWApplicationConfigUtils.getProperty((String)isIgnoreUnassignedXRateLimitHeaderKey, (String)String.valueOf(true));
        String isXRateLimitHeaderOn = DWApplicationConfigUtils.getProperty((String)isXRateLimitHeaderOnKey, (String)String.valueOf(true));
        String isCollectMetrics = DWApplicationConfigUtils.getProperty((String)isCollectMetricsKey, (String)String.valueOf(false));
        String isAutoFuseHttpStatusCode = DWApplicationConfigUtils.getProperty((String)isAutoFuseHttpStatusCodeKey, (String)String.valueOf(true));
        String inboundErrorHttpStatusCode = DWApplicationConfigUtils.getProperty((String)inboundErrorHttpStatusCodeKey, (String)String.valueOf(429));
        String outboundErrorHttpStatusCode = DWApplicationConfigUtils.getProperty((String)outboundErrorHttpStatusCodeKey, (String)String.valueOf(503));
        DWFuseOption option = new DWFuseOption();
        option.setIgnoreUnassignedXRateLimitHeader(isIgnoreUnassignedXRateLimitHeader);
        option.setXRateLimitHeaderOn(isXRateLimitHeaderOn);
        option.setCollectMetrics(isCollectMetrics);
        option.setAutoFuseHttpStatusCode(isAutoFuseHttpStatusCode);
        option.setInboundErrorHttpStatusCode(inboundErrorHttpStatusCode);
        option.setOutboundErrorHttpStatusCode(outboundErrorHttpStatusCode);
        return option;
    }

    private InboundConfig getInboundConfig(FuseInbound fuseInbound) {
        String key = fuseInbound.key();
        String enableKey = DapPropertiesInboundKey.enable((String)key);
        String maxWaitSecKey = DapPropertiesInboundKey.maxWaitSec((String)key);
        String limitKey = DapPropertiesInboundKey.limit((String)key);
        String resetNanoSecKey = DapPropertiesInboundKey.resetNanoSec((String)key);
        String enable = DWApplicationConfigUtils.getProperty((String)enableKey, (String)String.valueOf(fuseInbound.enable()));
        String maxWaitSec = DWApplicationConfigUtils.getProperty((String)maxWaitSecKey, (String)String.valueOf(fuseInbound.maxWaitSec()));
        String limit = DWApplicationConfigUtils.getProperty((String)limitKey, (String)String.valueOf(fuseInbound.limit()));
        String resetNanoSec = DWApplicationConfigUtils.getProperty((String)resetNanoSecKey, (String)String.valueOf(fuseInbound.resetNanoSec()));
        InboundConfig inboundConfig = new InboundConfigBuilder(key).enable(enable).maxWaitSec(maxWaitSec).limit(limit).resetNanoSec(resetNanoSec).build();
        return inboundConfig;
    }

    private OutboundConfig getOutboundConfig(FuseOutbound fuseOutbound) {
        String key = fuseOutbound.key();
        String enableKey = DapPropertiesOutboundKey.enable((String)key);
        String failureRateKey = DapPropertiesOutboundKey.failureRate((String)key);
        String openSecKey = DapPropertiesOutboundKey.openSec((String)key);
        String halfOpenCalculateSizeKey = DapPropertiesOutboundKey.halfOpenCalculateSize((String)key);
        String closeCalculateSizeKey = DapPropertiesOutboundKey.closeCalculateSize((String)key);
        String enable = DWApplicationConfigUtils.getProperty((String)enableKey, (String)String.valueOf(fuseOutbound.enable()));
        String failureRate = DWApplicationConfigUtils.getProperty((String)failureRateKey, (String)String.valueOf(fuseOutbound.failureRate()));
        String openSec = DWApplicationConfigUtils.getProperty((String)openSecKey, (String)String.valueOf(fuseOutbound.openSec()));
        String halfOpenCalculateSize = DWApplicationConfigUtils.getProperty((String)halfOpenCalculateSizeKey, (String)String.valueOf(fuseOutbound.halfOpenCalculateSize()));
        String closeCalculateSize = DWApplicationConfigUtils.getProperty((String)closeCalculateSizeKey, (String)String.valueOf(fuseOutbound.closeCalculateSize()));
        OutboundConfig outboundConfig = new OutboundConfigBuilder(key).enable(enable).failureRate(failureRate).openSec(openSec).halfOpenCalculateSize(halfOpenCalculateSize).closeCalculateSize(closeCalculateSize).build();
        return outboundConfig;
    }
}

