/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import com.digiwin.app.container.DWCommand;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWHeaderRepository;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.DWProxyHeader;
import com.digiwin.app.container.DWRestfulHeader;
import com.digiwin.app.container.DWRestfulParameters;
import com.digiwin.app.container.DWServiceRepository;
import com.digiwin.app.container.exceptions.DWHeaderNotFoundException;
import com.digiwin.app.container.exceptions.DWMethodNotAllowAnonymousException;
import com.digiwin.app.container.exceptions.DWMethodNotFoundException;
import com.digiwin.app.container.exceptions.DWServiceNotFoundException;
import com.digiwin.app.container.exceptions.DWSingletonAlreadyExistsException;
import com.digiwin.app.container.restful.DWRestfulRequestInfo;
import com.digiwin.app.container.restful.UrlNode;
import com.digiwin.app.container.restful.UrlParser;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.observer.FileModifiedListener;
import com.digiwin.app.service.DWOnLoad;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.concurrent.DWAsyncSupportService;
import com.digiwin.app.service.eai.EAICallback;
import com.digiwin.app.service.eai.EAIService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWContainerContext
implements Observer {
    private static Log _log = LogFactory.getLog(DWContainerContext.class);
    private Object _syncRoot = new Object();
    private static DWContainerContext _singleton;
    private DWHeaderRepository _headerRepository = null;
    private DWServiceRepository _serviceRepository = null;
    private Map<String, Map<String, Map<String, DWHeader>>> _headerMap = new HashMap<String, Map<String, Map<String, DWHeader>>>();
    private Map<DWHeader, Map<String, List<DWMethod>>> _methodMap = new HashMap<DWHeader, Map<String, List<DWMethod>>>();
    private Map<String, Map<DWRequestMethod, UrlNode>> _restfulMethodMap = new HashMap<String, Map<DWRequestMethod, UrlNode>>();
    private Map<String, Object> _eaiServiceHeaderMap = new HashMap<String, Object>();
    private Map<String, Object> _eaiServiceMethodMap = new HashMap<String, Object>();
    private Map<String, Object> _eaiCallbackHeaderMap = new HashMap<String, Object>();
    private Map<String, Object> _eaiCallbackMethodMap = new HashMap<String, Object>();
    private List<DWRestfulHeader> allRestfulHeaderList = new ArrayList<DWRestfulHeader>();

    public DWContainerContext(DWHeaderRepository headerRepository, DWServiceRepository serviceRepository) {
        if (headerRepository == null) {
            throw new IllegalArgumentException();
        }
        if (serviceRepository == null) {
            throw new IllegalArgumentException();
        }
        if (_singleton != null) {
            throw new DWSingletonAlreadyExistsException(this);
        }
        _singleton = this;
        this._headerRepository = headerRepository;
        this._serviceRepository = serviceRepository;
        this.refresh();
        FileModifiedListener.getInstance().addObserver((Observer)this);
    }

    public static DWContainerContext getInstance() {
        return _singleton;
    }

    public Object invoke(DWCommand command, Map<String, Object> profile) throws Exception {
        String moduleName = command.getModuleName();
        String serviceName = command.getServiceName();
        String methodName = command.getMethodName();
        DWDefaultParameters parameters = new DWDefaultParameters(command.getParameters());
        return this.invoke(moduleName, serviceName, methodName, parameters, profile);
    }

    public boolean supportAsyncInvoke(DWCommand command, Map<String, Object> profile) throws Exception {
        boolean support = false;
        String moduleName = command.getModuleName();
        String serviceName = command.getServiceName();
        String methodName = command.getMethodName();
        DWDefaultParameters parameters = new DWDefaultParameters(command.getParameters());
        if (moduleName == null) {
            throw new IllegalArgumentException();
        }
        if (serviceName == null) {
            throw new IllegalArgumentException();
        }
        if (methodName == null) {
            throw new IllegalArgumentException();
        }
        if (profile == null) {
            throw new IllegalArgumentException();
        }
        DWHeader header = this.getHeader(moduleName, serviceName);
        if (header == null) {
            throw new DWHeaderNotFoundException(moduleName, serviceName);
        }
        DWMethod method = this.getMethod(header, methodName, parameters);
        if (method == null) {
            throw new DWMethodNotFoundException(moduleName, serviceName, methodName, parameters);
        }
        if (!method.allowAnonymous() && profile.size() == 0) {
            throw new DWMethodNotAllowAnonymousException(moduleName, serviceName, methodName, parameters);
        }
        Object service = this.getService(header, method);
        support = service instanceof DWAsyncSupportService;
        return support;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(String moduleName, String serviceName, String methodName, DWParameters parameters, Map<String, Object> profile) throws Exception {
        Object service;
        if (moduleName == null) {
            throw new IllegalArgumentException();
        }
        if (serviceName == null) {
            throw new IllegalArgumentException();
        }
        if (methodName == null) {
            throw new IllegalArgumentException();
        }
        if (parameters == null) {
            throw new IllegalArgumentException();
        }
        if (profile == null) {
            throw new IllegalArgumentException();
        }
        long invokeTimestamp = this.logInvoke(moduleName, serviceName, methodName, parameters);
        DWHeader header = this.getHeader(moduleName, serviceName);
        if (header == null) {
            throw new DWHeaderNotFoundException(moduleName, serviceName);
        }
        DWMethod method = this.getMethod(header, methodName, parameters);
        if (method == null) {
            throw new DWMethodNotFoundException(moduleName, serviceName, methodName, parameters);
        }
        if (!method.allowAnonymous() && profile.size() == 0) {
            throw new DWMethodNotAllowAnonymousException(moduleName, serviceName, methodName, parameters);
        }
        String currentModuleName = DWModuleClassLoader.getCurrentModuleName();
        if (currentModuleName == null) {
            currentModuleName = moduleName;
        }
        if ((service = this.getService(header, method)) == null) {
            throw new DWServiceNotFoundException(moduleName, serviceName);
        }
        DWServiceContext.getContext().setModuleName(moduleName);
        DWServiceContext.getContext().setProfile(profile);
        if (parameters != null) {
            DWServiceContext.getContext().setUUID(parameters.getIdempotentId());
        }
        Date startTime = Calendar.getInstance().getTime();
        Object result = null;
        try {
            DWModuleClassLoader.setCurrentModuleName((String)moduleName);
            result = method.invoke(service, parameters);
        }
        finally {
            DWModuleClassLoader.setCurrentModuleName((String)currentModuleName);
        }
        Date endTime = Calendar.getInstance().getTime();
        long diffs = endTime.getTime() - startTime.getTime();
        DWServiceContext.getContext().pushDuration(diffs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeEai(DWHeader header, DWMethod method, String moduleName, String serviceName, DWParameters parameters, Map<String, Object> profile) throws Exception {
        Object service;
        String currentModuleName = DWModuleClassLoader.getCurrentModuleName();
        if (currentModuleName == null) {
            currentModuleName = moduleName;
        }
        if ((service = this.getService(header, method)) == null) {
            throw new DWServiceNotFoundException(moduleName, serviceName);
        }
        DWServiceContext.getContext().setModuleName(moduleName);
        DWServiceContext.getContext().setProfile(profile);
        DWServiceContext.getContext().setUUID(new DWDefaultParameters().getIdempotentId());
        Date startTime = Calendar.getInstance().getTime();
        Object result = null;
        try {
            DWModuleClassLoader.setCurrentModuleName((String)moduleName);
            result = method.invoke(service, parameters);
        }
        finally {
            DWModuleClassLoader.setCurrentModuleName((String)currentModuleName);
        }
        Date endTime = Calendar.getInstance().getTime();
        long diffs = endTime.getTime() - startTime.getTime();
        DWServiceContext.getContext().pushDuration(diffs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeRestful(DWRestfulHeader header, String moduleName, String serviceName, DWRestfulParameters restfulParameters, Map<String, Object> profile) throws Exception {
        Object service;
        DWMethod method = restfulParameters.getMethod();
        String currentModuleName = DWModuleClassLoader.getCurrentModuleName();
        if (currentModuleName == null) {
            currentModuleName = moduleName;
        }
        if ((service = this.getService(header, method)) == null) {
            throw new DWServiceNotFoundException(moduleName, serviceName);
        }
        DWServiceContext.getContext().setModuleName(moduleName);
        DWServiceContext.getContext().setProfile(profile);
        DWServiceContext.getContext().setUUID(new DWDefaultParameters().getIdempotentId());
        Date startTime = Calendar.getInstance().getTime();
        Object result = null;
        try {
            DWModuleClassLoader.setCurrentModuleName((String)moduleName);
            result = method.invoke(service, restfulParameters);
        }
        finally {
            DWModuleClassLoader.setCurrentModuleName((String)currentModuleName);
        }
        Date endTime = Calendar.getInstance().getTime();
        long diffs = endTime.getTime() - startTime.getTime();
        DWServiceContext.getContext().pushDuration(diffs);
        return result;
    }

    public boolean isDWMethodAllowAnonymous(DWMethod method) {
        return method.allowAnonymous();
    }

    public DWHeader getDWHeader(String moduleName, String serviceName) {
        return this.getHeader(moduleName, serviceName);
    }

    public DWMethod getDWMethod(DWHeader header, String methodName, DWParameters parameters) {
        return this.getMethod(header, methodName, parameters);
    }

    public DWMethod getDWRestfulMethod(String moduleName, DWRestfulRequestInfo request, DWRequestMethod httpMethod) {
        if (!this._restfulMethodMap.containsKey(moduleName)) {
            return null;
        }
        Map<DWRequestMethod, UrlNode> urlNodeMap = this._restfulMethodMap.get(moduleName);
        UrlNode urlNode = urlNodeMap.get(httpMethod);
        UrlParser.parse(urlNode, 0, request);
        return request.getDWMethod();
    }

    public DWHeader getEaiServiceHeader(String eaiServiceId) {
        return (DWHeader)this._eaiServiceHeaderMap.get(eaiServiceId);
    }

    public DWMethod getEaiServiceMethod(String eaiServiceId) {
        return this._eaiServiceMethodMap.getOrDefault(eaiServiceId, null);
    }

    public DWHeader getEaiCallbackHeader(String eaiServiceId) {
        return (DWHeader)this._eaiCallbackHeaderMap.get(eaiServiceId);
    }

    public DWMethod getEaiCallbackMethod(String eaiServiceId) {
        return this._eaiCallbackMethodMap.getOrDefault(eaiServiceId, null);
    }

    private long logInvoke(String moduleName, String serviceName, String methodName, DWParameters parameters) {
        String[] names;
        StringBuffer invokeMessage = new StringBuffer();
        long timestamp = System.currentTimeMillis();
        long threadId = Thread.currentThread().getId();
        invokeMessage.append(">invoke[").append(timestamp).append("]").append("{").append(threadId).append("}").append(">").append(moduleName).append(".").append(serviceName).append(".").append(methodName).append("(");
        if (parameters != null && (names = parameters.getNames()) != null) {
            for (int i = 0; i < names.length; ++i) {
                invokeMessage.append(names[i]);
                if (i == names.length - 1) continue;
                invokeMessage.append(", ");
            }
        }
        invokeMessage.append(")");
        invokeMessage.append(" input: " + (parameters == null ? "null" : parameters.toString()));
        _log.info((Object)invokeMessage.toString());
        return timestamp;
    }

    private void logResult(long invokeTimestamp, Object result) throws Exception {
        StringBuffer resultMessage = new StringBuffer();
        resultMessage.append(">result[").append(invokeTimestamp).append("]>").append(result);
        _log.info((Object)resultMessage.toString());
    }

    private void logException(long invokeTimestamp, Throwable e) throws Exception {
        StringBuffer exceptionMessage = new StringBuffer();
        exceptionMessage.append(">Exception[").append(invokeTimestamp).append("]>");
        _log.error((Object)exceptionMessage.toString(), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DWHeader getHeader(String moduleName, String serviceName) {
        if (moduleName == null) {
            throw new IllegalArgumentException();
        }
        if (serviceName == null) {
            throw new IllegalArgumentException();
        }
        Object object = this._syncRoot;
        synchronized (object) {
            for (Map<String, Map<String, DWHeader>> headers : this._headerMap.values()) {
                if (!headers.containsKey(moduleName) || !headers.get(moduleName).containsKey(serviceName)) continue;
                return headers.get(moduleName).get(serviceName);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DWMethod getMethod(DWHeader header, String methodName, DWParameters parameters) {
        if (header == null) {
            throw new IllegalArgumentException();
        }
        if (methodName == null) {
            throw new IllegalArgumentException();
        }
        if (parameters == null) {
            throw new IllegalArgumentException();
        }
        Object object = this._syncRoot;
        synchronized (object) {
            if (!this._methodMap.containsKey(header)) {
                return null;
            }
            if (!this._methodMap.get(header).containsKey(methodName)) {
                return null;
            }
            for (DWMethod method : this._methodMap.get(header).get(methodName)) {
                if (!method.isMatch(parameters)) continue;
                return method;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String moduleName) {
        List<DWHeader> headerList = this._headerRepository.getHeaders(moduleName);
        if (headerList == null) {
            throw new IllegalStateException();
        }
        List<DWHeader> dwHeaderList = headerList;
        ArrayList<DWRestfulHeader> dwRestfulHeaderList = new ArrayList<DWRestfulHeader>();
        for (DWHeader header : headerList) {
            if (!(header instanceof DWRestfulHeader)) continue;
            dwRestfulHeaderList.add((DWRestfulHeader)header);
        }
        dwHeaderList.removeAll(dwRestfulHeaderList);
        this.updateModuleRestFulHeaders(moduleName, dwRestfulHeaderList);
        Map<String, Map<DWRequestMethod, UrlNode>> restfulMethodMap = this.createRestfulMethodMap(this.allRestfulHeaderList);
        List<DWHeader> allHeaderList = this._headerRepository.getAllHeader();
        Map<String, Map<String, Object>> eaiMap = this.createEaiMap(allHeaderList);
        Map<String, Object> eaiServiceHeaderMap = eaiMap.get("eaiServiceHeader");
        if (eaiServiceHeaderMap == null) {
            throw new IllegalStateException();
        }
        Map<String, Object> eaiServiceMethodMap = eaiMap.get("eaiServiceMethod");
        if (eaiServiceMethodMap == null) {
            throw new IllegalStateException();
        }
        Map<String, Object> eaiCallbackHeaderMap = eaiMap.get("eaiCallbackHeader");
        if (eaiCallbackHeaderMap == null) {
            throw new IllegalStateException();
        }
        Map<String, Object> eaiCallbackMethodMap = eaiMap.get("eaiCallbackMethod");
        if (eaiCallbackMethodMap == null) {
            throw new IllegalStateException();
        }
        Object object = this._syncRoot;
        synchronized (object) {
            this._restfulMethodMap = restfulMethodMap;
            this._eaiServiceHeaderMap = eaiServiceHeaderMap;
            this._eaiServiceMethodMap = eaiServiceMethodMap;
            this._eaiCallbackHeaderMap = eaiCallbackHeaderMap;
            this._eaiCallbackMethodMap = eaiCallbackMethodMap;
            this.createHeaderMap(dwHeaderList, true);
            this.createMethodMap(dwHeaderList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        List<DWHeader> headerList = this._headerRepository.getAllHeader();
        if (headerList == null) {
            throw new IllegalStateException();
        }
        List<Object> dwHeaderList = new ArrayList();
        ArrayList<DWRestfulHeader> dwRestfulHeaderList = new ArrayList<DWRestfulHeader>();
        for (DWHeader header : headerList) {
            if (!(header instanceof DWRestfulHeader)) continue;
            dwRestfulHeaderList.add((DWRestfulHeader)header);
        }
        this.allRestfulHeaderList = dwRestfulHeaderList;
        dwHeaderList = headerList;
        dwHeaderList.removeAll(dwRestfulHeaderList);
        Map<String, Map<DWRequestMethod, UrlNode>> restfulMethodMap = this.createRestfulMethodMap(dwRestfulHeaderList);
        if (restfulMethodMap == null) {
            throw new IllegalStateException();
        }
        Map<String, Map<String, Object>> eaiMap = this.createEaiMap(dwHeaderList);
        Map<String, Object> eaiServiceHeaderMap = eaiMap.get("eaiServiceHeader");
        if (eaiServiceHeaderMap == null) {
            throw new IllegalStateException();
        }
        Map<String, Object> eaiServiceMethodMap = eaiMap.get("eaiServiceMethod");
        if (eaiServiceMethodMap == null) {
            throw new IllegalStateException();
        }
        Map<String, Object> eaiCallbackHeaderMap = eaiMap.get("eaiCallbackHeader");
        if (eaiCallbackHeaderMap == null) {
            throw new IllegalStateException();
        }
        Map<String, Object> eaiCallbackMethodMap = eaiMap.get("eaiCallbackMethod");
        if (eaiCallbackMethodMap == null) {
            throw new IllegalStateException();
        }
        Object object = this._syncRoot;
        synchronized (object) {
            this._restfulMethodMap = restfulMethodMap;
            this._eaiServiceHeaderMap = eaiServiceHeaderMap;
            this._eaiServiceMethodMap = eaiServiceMethodMap;
            this._eaiCallbackHeaderMap = eaiCallbackHeaderMap;
            this._eaiCallbackMethodMap = eaiCallbackMethodMap;
            this.createHeaderMap(dwHeaderList);
            this.createMethodMap(dwHeaderList);
        }
    }

    public Object getService(DWHeader header, DWMethod method) throws Exception {
        if (header == null) {
            throw new IllegalArgumentException();
        }
        return this._serviceRepository.getService(header, method);
    }

    private Map<String, Map<DWRequestMethod, UrlNode>> createRestfulMethodMap(List<DWRestfulHeader> restfulHeaderList) {
        HashMap<String, Map<DWRequestMethod, UrlNode>> urlNodeMap = new HashMap<String, Map<DWRequestMethod, UrlNode>>();
        for (DWRestfulHeader header : restfulHeaderList) {
            Method[] methods;
            String moduleName = header.getModuleName();
            Map<DWRequestMethod, UrlNode> url = null;
            if (urlNodeMap.containsKey(moduleName)) {
                url = (Map)urlNodeMap.get(moduleName);
            } else {
                url = new HashMap();
                url.put(DWRequestMethod.GET, new UrlNode("getRoot"));
                url.put(DWRequestMethod.HEAD, new UrlNode("headRoot"));
                url.put(DWRequestMethod.POST, new UrlNode("postRoot"));
                url.put(DWRequestMethod.PUT, new UrlNode("putRoot"));
                url.put(DWRequestMethod.PATCH, new UrlNode("patchRoot"));
                url.put(DWRequestMethod.DELETE, new UrlNode("deleteRoot"));
                url.put(DWRequestMethod.OPTIONS, new UrlNode("optionsRoot"));
                url.put(DWRequestMethod.TRACE, new UrlNode("traceRoot"));
            }
            Class<?> interfaceType = header.getServiceType();
            if (!interfaceType.isAnnotationPresent(DWRestfulService.class)) continue;
            for (Method method : methods = interfaceType.getMethods()) {
                if (!method.isAnnotationPresent(DWRequestMapping.class)) continue;
                DWRequestMapping requestMapping = method.getAnnotation(DWRequestMapping.class);
                String path = requestMapping.path();
                for (DWRequestMethod httpMethod : requestMapping.method()) {
                    UrlNode urlNode = (UrlNode)url.get(httpMethod);
                    urlNode.addUrl(path, new DWMethod(method));
                    url.put(httpMethod, urlNode);
                }
            }
            urlNodeMap.put(moduleName, url);
        }
        return urlNodeMap;
    }

    private Map<String, Map<String, Object>> createEaiMap(List<DWHeader> headerList) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        HashMap<String, DWHeader> eaiServiceHeaderMap = new HashMap<String, DWHeader>();
        HashMap<String, DWMethod> eaiServiceMethodMap = new HashMap<String, DWMethod>();
        HashMap<String, DWHeader> eaiCallbackHeaderMap = new HashMap<String, DWHeader>();
        HashMap<String, DWMethod> eaiCallbackMethodMap = new HashMap<String, DWMethod>();
        for (DWHeader header : headerList) {
            Map<String, List<DWMethod>> methods = header.getDWMethods();
            for (Map.Entry<String, List<DWMethod>> entry : methods.entrySet()) {
                List<DWMethod> dwMethods = entry.getValue();
                for (DWMethod dwMethod : dwMethods) {
                    Method method = dwMethod.getMethod();
                    if (method.isAnnotationPresent(EAIService.class)) {
                        EAIService eaiService = method.getAnnotation(EAIService.class);
                        String eaiServiceId = eaiService.id();
                        eaiServiceHeaderMap.put(eaiServiceId, header);
                        eaiServiceMethodMap.put(eaiServiceId, dwMethod);
                    }
                    if (!method.isAnnotationPresent(EAICallback.class)) continue;
                    EAICallback eaiCallback = method.getAnnotation(EAICallback.class);
                    String eaiCallbackId = eaiCallback.id();
                    eaiCallbackHeaderMap.put(eaiCallbackId, header);
                    eaiCallbackMethodMap.put(eaiCallbackId, dwMethod);
                }
            }
        }
        result.put("eaiServiceHeader", eaiServiceHeaderMap);
        result.put("eaiServiceMethod", eaiServiceMethodMap);
        result.put("eaiCallbackHeader", eaiCallbackHeaderMap);
        result.put("eaiCallbackMethod", eaiCallbackMethodMap);
        return result;
    }

    public List<String> getEaiServiceList() {
        ArrayList<String> eaiServiceList = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this._eaiServiceMethodMap.entrySet()) {
            String eaiServiceId = entry.getKey();
            eaiServiceList.add(eaiServiceId);
        }
        return eaiServiceList;
    }

    private void createHeaderMap(List<DWHeader> headerList) {
        this.createHeaderMap(headerList, false);
    }

    private void createHeaderMap(List<DWHeader> headerList, boolean refreshable) {
        if (headerList == null) {
            throw new IllegalArgumentException();
        }
        String defautDubboMethod = "dubbo";
        try {
            for (DWHeader header : headerList) {
                Map<Object, Object> headerMap;
                String headerTypeName = defautDubboMethod;
                if (header instanceof DWProxyHeader) {
                    headerTypeName = ((DWProxyHeader)((Object)header)).getProxyName();
                }
                if (!this._headerMap.containsKey(headerTypeName)) {
                    headerMap = new HashMap();
                    this._headerMap.put(headerTypeName, headerMap);
                }
                if (!(headerMap = this._headerMap.get(headerTypeName)).containsKey(header.getModuleName())) {
                    headerMap.put(header.getModuleName(), new HashMap());
                }
                if (((Map)headerMap.get(header.getModuleName())).containsKey(header.getServiceName()) && !refreshable) continue;
                ((Map)headerMap.get(header.getModuleName())).put(header.getServiceName(), header);
            }
        }
        catch (Throwable e) {
            _log.error((Object)"\u521d\u59cb\u5316\u670d\u52a1\u63a5\u53e3\u53d1\u751f\u4e25\u91cd\u9519\u8bef!", e);
        }
    }

    private void createMethodMap(List<DWHeader> headerList) {
        if (headerList == null) {
            throw new IllegalArgumentException();
        }
        DWHeader header = null;
        try {
            for (int i = 0; i < headerList.size(); ++i) {
                header = headerList.get(i);
                Map<String, List<DWMethod>> dwMethods = header.getDWMethods();
                this._methodMap.put(header, dwMethods);
            }
        }
        catch (Throwable e) {
            if (header != null) {
                String serviceInfo = null;
                serviceInfo = header.getServiceType() != null ? header.getServiceType().getName() : String.format("%s.%s", header.getModuleName(), header.getServiceName());
                _log.error((Object)String.format("\u521d\u59cb\u5316\u670d\u52a1\u63a5\u53e3 [%s] \u53d1\u751f\u4e25\u91cd\u9519\u8bef!", serviceInfo), e);
            }
            _log.error((Object)"createMethodMap unknown error!", e);
        }
    }

    private void updateModuleRestFulHeaders(String moduleName, List<DWRestfulHeader> moduleRestfulHeaderList) {
        Map<String, List<DWRestfulHeader>> moduleRefulHeadersMap = this.createModuleHeadersMap(moduleRestfulHeaderList);
        Map<String, List<DWRestfulHeader>> allRefulHeadersMap = this.createModuleHeadersMap(this.allRestfulHeaderList);
        List<DWRestfulHeader> list = moduleRefulHeadersMap.get(moduleName);
        if (list == null) {
            list = new ArrayList<DWRestfulHeader>();
        }
        allRefulHeadersMap.put(moduleName, list);
        this.allRestfulHeaderList.clear();
        for (Map.Entry<String, List<DWRestfulHeader>> entry : allRefulHeadersMap.entrySet()) {
            List<DWRestfulHeader> restfulHeaderList = entry.getValue();
            this.allRestfulHeaderList.addAll(restfulHeaderList);
        }
    }

    private Map<String, List<DWRestfulHeader>> createModuleHeadersMap(List<DWRestfulHeader> list) {
        HashMap<String, List<DWRestfulHeader>> result = new HashMap<String, List<DWRestfulHeader>>();
        for (DWRestfulHeader header : list) {
            List<DWRestfulHeader> newList;
            String moduleName = header.getModuleName();
            if (result.containsKey(moduleName)) {
                newList = (List)result.get(moduleName);
                newList.add(header);
            } else {
                newList = new ArrayList();
            }
            result.put(moduleName, newList);
        }
        return result;
    }

    @Override
    public void update(Observable o, Object arg) {
        try {
            Map param = (Map)arg;
            String moduleName = param.getOrDefault("moduleName", "");
            this._headerRepository.refresh(moduleName);
            this._serviceRepository.refresh(moduleName);
            this.invokeDWOnloadMethods(moduleName);
            this.refresh(moduleName);
        }
        catch (Exception e) {
            _log.error((Object)e);
        }
    }

    public void invokeDWOnloadMethods(String moduleName) throws Exception {
        List<DWHeader> headers = this._headerRepository.getHeaders(moduleName);
        this.invokeDWOnloadMethods(headers);
    }

    public void invokeDWOnloadMethods() throws Exception {
        List<DWHeader> headers = this._headerRepository.getAllHeader();
        this.invokeDWOnloadMethods(headers);
    }

    public void invokeDWOnloadMethods(List<DWHeader> headers) throws Exception {
        for (DWHeader header : headers) {
            Map<String, List<DWMethod>> methodMap = header.getDWMethods();
            for (String key : methodMap.keySet()) {
                if (null == methodMap.get(key)) continue;
                List<DWMethod> methodList = methodMap.get(key);
                for (DWMethod method : methodList) {
                    if (null == method || null == method.getMethod().getAnnotationsByType(DWOnLoad.class) || ((DWOnLoad[])method.getMethod().getAnnotationsByType(DWOnLoad.class)).length <= 0) continue;
                    DWDefaultParameters defaultParameters = new DWDefaultParameters();
                    for (Parameter param : method.getMethod().getParameters()) {
                        defaultParameters.put(param.getName(), null);
                    }
                    Map<String, Object> profile = DWServiceContext.getContext().getProfile();
                    if (profile == null) {
                        profile = Collections.emptyMap();
                    }
                    this.invoke(header.getModuleName(), header.getServiceName(), method.getMethodName(), defaultParameters, profile);
                }
            }
        }
    }

    static enum EaiMapType {
        method,
        header;

    }

    static enum EaiTargetType {
        service,
        callback;

    }
}

