/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWServiceInvocationProcessor;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.service.DWServiceLocationInfo;

public class DWModuleServiceInvocationProcessor
implements DWServiceInvocationProcessor {
    private static ThreadLocal<String> _currentModuleName;

    @Override
    public void beforeInvoke(DWServiceLocationInfo locationInfo) {
        String moduleName;
        if (_currentModuleName == null) {
            _currentModuleName = new ThreadLocal();
        }
        _currentModuleName.set((moduleName = DWModuleClassLoader.getCurrentModuleName()) == null ? locationInfo.getGroup() : moduleName);
    }

    @Override
    public void onInvoke(DWMethod method, Object service, DWServiceLocationInfo locationInfo) {
        DWModuleClassLoader.setCurrentModuleName((String)locationInfo.getGroup());
    }

    @Override
    public void afterInvoke(DWMethod method, Object service, DWServiceLocationInfo locationInfo) {
        DWModuleClassLoader.setCurrentModuleName((String)_currentModuleName.get());
    }

    @Override
    public void beforeInvoke(DWHeader header, DWMethod method) {
        String moduleName;
        if (_currentModuleName == null) {
            _currentModuleName = new ThreadLocal();
        }
        DWModuleClassLoader.setCurrentModuleName((String)((moduleName = DWModuleClassLoader.getCurrentModuleName()) == null ? header.getModuleName() : moduleName));
        _currentModuleName.set(moduleName == null ? header.getModuleName() : moduleName);
    }

    @Override
    public void onInvoke(DWHeader header, DWMethod method, Object service) {
        DWModuleClassLoader.setCurrentModuleName((String)header.getModuleName());
    }

    @Override
    public void afterInvoke(DWHeader header, DWMethod method, Object service) {
        DWModuleClassLoader.setCurrentModuleName((String)_currentModuleName.get());
    }
}

