/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.concurrent;

import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.concurrent.DWServiceCallable;
import com.digiwin.app.container.concurrent.DWSubmitInfo;
import com.digiwin.app.service.DWServiceContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class DWExecutorService {
    private int _threadNumber;
    private ExecutorService _originalExecutorService;

    private ExecutorService getOriginalExecutorService() {
        if (this._originalExecutorService == null) {
            this._originalExecutorService = Executors.newFixedThreadPool(this._threadNumber);
        }
        return this._originalExecutorService;
    }

    public DWExecutorService(int nThreads) {
        if (nThreads <= 0) {
            throw new IllegalArgumentException("nThreads can't less than zero!");
        }
        this._threadNumber = nThreads;
    }

    public Future<Object> sumbit(DWSubmitInfo submitInfo) throws Exception {
        ArrayList<DWSubmitInfo> submitInfos = new ArrayList<DWSubmitInfo>();
        submitInfos.add(submitInfo);
        return this.submit(submitInfos).get(0);
    }

    public List<Future<Object>> submit(List<DWSubmitInfo> submitInfos) throws Exception {
        if (submitInfos == null) {
            throw new IllegalArgumentException("submitInfos is null!");
        }
        ArrayList<Future<Object>> futureResult = new ArrayList<Future<Object>>();
        DWContainerContext containerContext = DWContainerContext.getInstance();
        ArrayList<DWSubmitInfo> supportAsyncInfos = new ArrayList<DWSubmitInfo>();
        ArrayList<DWSubmitInfo> notSupportAsyncInfos = new ArrayList<DWSubmitInfo>();
        for (DWSubmitInfo submitInfo : submitInfos) {
            boolean supportAsyncInvoke = containerContext.supportAsyncInvoke(submitInfo.getCommand(), submitInfo.getProfile());
            if (supportAsyncInvoke) {
                supportAsyncInfos.add(submitInfo);
                continue;
            }
            notSupportAsyncInfos.add(submitInfo);
        }
        futureResult.addAll(this.submitByStandardInvocation(supportAsyncInfos));
        futureResult.addAll(this.submitByOriginalExecutor(notSupportAsyncInfos));
        return futureResult;
    }

    private List<Future<Object>> submitByStandardInvocation(List<DWSubmitInfo> submitInfos) throws Exception {
        ArrayList<Future<Object>> futureResult = new ArrayList<Future<Object>>();
        DWContainerContext containerContext = DWContainerContext.getInstance();
        try {
            for (DWSubmitInfo submitInfo : submitInfos) {
                DWServiceContext.getContext().setAsync(true);
                containerContext.invoke(submitInfo.getCommand(), submitInfo.getProfile());
                Future currentFuture = DWServiceContext.getContext().getFuture();
                futureResult.add(currentFuture);
            }
        }
        catch (Exception e) {
            DWServiceContext.getContext().setAsync(false);
            throw e;
        }
        return futureResult;
    }

    private List<Future<Object>> submitByOriginalExecutor(List<DWSubmitInfo> submitInfos) throws Exception {
        ArrayList<Future<Object>> futureResult = new ArrayList<Future<Object>>();
        ExecutorService originalExecutorService = this.getOriginalExecutorService();
        try {
            for (DWSubmitInfo submitInfo : submitInfos) {
                DWServiceCallable serviceCallable = new DWServiceCallable(submitInfo.getCommand(), submitInfo.getProfile());
                futureResult.add(originalExecutorService.submit(serviceCallable));
            }
        }
        catch (Exception e) {
            this.shutdownNow();
        }
        return futureResult;
    }

    public void shutdown() {
        if (this._originalExecutorService != null) {
            this._originalExecutorService.shutdown();
            this._originalExecutorService = null;
        }
    }

    public List<Runnable> shutdownNow() {
        if (this._originalExecutorService != null) {
            List<Runnable> result = this._originalExecutorService.shutdownNow();
            this._originalExecutorService = null;
            return result;
        }
        return Collections.emptyList();
    }
}

