/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWServiceRegistry;
import com.digiwin.app.container.DWServiceRepository;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.DWService;
import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DWAbstractServiceRepository<H extends DWHeader>
implements DWServiceRepository,
DWServiceRegistry {
    Map<String, List<DWServiceInfo>> serviceMap = new HashMap<String, List<DWServiceInfo>>();
    private Class<H> acceptableHeaderClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    @Override
    public void register(Map<String, List<DWServiceInfo>> services) {
        Objects.requireNonNull(services);
        services.entrySet().forEach(item -> this.register((String)item.getKey(), (List)item.getValue()));
    }

    @Override
    public void register(String groupName, List<DWServiceInfo> services) {
        this.serviceMap.put(groupName, services);
    }

    @Override
    public DWService getService(DWHeader header, DWMethod method) throws Exception {
        if (!this.accept(header)) {
            return null;
        }
        List<DWServiceInfo> serviceList = this.serviceMap.get(header.getModuleName());
        if (serviceList == null) {
            return null;
        }
        DWServiceInfo serviceInfo = serviceList.stream().filter(s -> s.getInterfaceType() == header.getServiceType()).findFirst().orElse(null);
        return serviceInfo == null ? null : serviceInfo.getInstance();
    }

    @Override
    public Map<String, List<DWServiceInfo>> getServiceInfos() {
        return this.serviceMap;
    }

    @Override
    public List<DWServiceInfo> getServiceInfos(String groupName) {
        if (this.serviceMap.containsKey(groupName)) {
            return this.serviceMap.get(groupName);
        }
        return Collections.emptyList();
    }

    @Override
    public DWServiceInfo getServiceInfo(String groupName, String serviceName) {
        List<DWServiceInfo> serviceList = this.getServiceInfos(groupName);
        DWServiceInfo targetInfo = serviceList.stream().filter(s -> s.getInterfaceType().getSimpleName().equals(serviceName)).findFirst().orElse(null);
        return targetInfo;
    }

    protected boolean accept(DWHeader header) {
        return this.acceptableHeaderClass.isInstance(header);
    }

    @Override
    public void refresh(String moduleName) throws Exception {
    }
}

