/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import com.digiwin.app.container.DWCommand;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWHeaderRepository;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.DWServiceInvocationProcessor;
import com.digiwin.app.container.DWServiceRepository;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWHeaderNotFoundException;
import com.digiwin.app.container.exceptions.DWMethodNotAllowAnonymousException;
import com.digiwin.app.container.exceptions.DWMethodNotFoundException;
import com.digiwin.app.container.exceptions.DWServiceNotFoundException;
import com.digiwin.app.container.exceptions.DWSingletonAlreadyExistsException;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.DWOnLoad;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.DWServiceLocationInfo;
import com.digiwin.app.service.DWServiceLookupProcessor;
import com.digiwin.app.service.DWSimpleServiceLocationInfo;
import com.digiwin.app.service.concurrent.DWAsyncSupportService;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWContainerContext
implements Observer {
    private static Log _log = LogFactory.getLog(DWContainerContext.class);
    private static DWContainerContext _singleton;
    private DWHeaderRepository _headerRepository;
    private DWServiceRepository _serviceRepository;
    private static boolean hotDeploy;
    private List<DWServiceInvocationProcessor> _serviceInvocationProcessors;
    private DWServiceLookupProcessor _serviceLookupProcessor;

    public DWContainerContext(DWHeaderRepository headerRepository, DWServiceRepository serviceRepository) {
        this(headerRepository, serviceRepository, null, null);
    }

    public DWContainerContext(DWHeaderRepository headerRepository, DWServiceRepository serviceRepository, DWServiceInvocationProcessor[] serviceInvocationProcessors, DWServiceLookupProcessor lookupProcessor) {
        if (headerRepository == null) {
            throw new IllegalArgumentException();
        }
        if (serviceRepository == null) {
            throw new IllegalArgumentException();
        }
        this._serviceInvocationProcessors = serviceInvocationProcessors == null ? Collections.emptyList() : Arrays.asList(serviceInvocationProcessors);
        this._serviceLookupProcessor = lookupProcessor;
        if (this._serviceLookupProcessor == null) {
            _log.warn((Object)"DWContainerContext lookup processor is null.");
        }
        if (_singleton != null) {
            throw new DWSingletonAlreadyExistsException((Object)this);
        }
        _singleton = this;
        this._headerRepository = headerRepository;
        this._serviceRepository = serviceRepository;
    }

    public static DWContainerContext getInstance() {
        return _singleton;
    }

    public static void setHotDeploy(boolean hotDeploy) {
        DWContainerContext.hotDeploy = hotDeploy;
    }

    public static boolean getHotDeploy() {
        return hotDeploy;
    }

    public Object invoke(DWCommand command, Map<String, Object> profile) throws Exception {
        String moduleName = command.getModuleName();
        String serviceName = command.getServiceName();
        String methodName = command.getMethodName();
        DWDefaultParameters parameters = new DWDefaultParameters(command.getParameters());
        return this.invoke(moduleName, serviceName, methodName, parameters, profile);
    }

    public Object invoke(String groupName, String serviceName, String methodName, DWParameters parameters, Map<String, Object> profile) throws Exception {
        if (groupName == null) {
            throw new IllegalArgumentException();
        }
        if (serviceName == null) {
            throw new IllegalArgumentException();
        }
        if (methodName == null) {
            throw new IllegalArgumentException();
        }
        if (parameters == null) {
            throw new IllegalArgumentException();
        }
        if (profile == null) {
            throw new IllegalArgumentException();
        }
        DWHeader header = this.getDWHeader(groupName, serviceName);
        if (header == null) {
            throw new DWHeaderNotFoundException(groupName, serviceName);
        }
        DWMethod method = this.getDWMethod(header, methodName, parameters);
        if (method == null) {
            throw new DWMethodNotFoundException(groupName, serviceName, methodName, parameters);
        }
        return this.invoke(header, method, parameters, profile);
    }

    public Object invoke(DWTargetAPI api, DWParameters parameters, Map<String, Object> profile) throws Exception {
        Objects.requireNonNull(api);
        if (api.getHeader() == null) {
            throw new DWArgumentException("api.header", "Header is null!");
        }
        if (api.getMethod() == null) {
            throw new DWArgumentException("api.method", "Method is null!");
        }
        return this.invoke(api.getHeader(), api.getMethod(), parameters, profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invoke(DWHeader header, DWMethod method, DWParameters parameters, Map<String, Object> profile) throws Exception {
        Object result;
        if (!method.allowAnonymous() && profile.size() == 0) {
            throw new DWMethodNotAllowAnonymousException(header.getModuleName(), header.getServiceName(), method.getMethodName(), parameters);
        }
        if (method.allowCrossTenant()) {
            DWServiceContext.getContext().setAllowCrossTenant(true);
        }
        this._serviceInvocationProcessors.forEach(p -> p.beforeInvoke(header, method));
        Object service = this.getService(header, method);
        if (service == null) {
            throw new DWServiceNotFoundException(header.getModuleName(), header.getModuleName());
        }
        DWServiceContext.getContext().setModuleName(header.getModuleName());
        DWServiceContext.getContext().setProfile(profile);
        DWServiceContext.getContext().setUUID(parameters.getIdempotentId());
        Date startTime = Calendar.getInstance().getTime();
        try {
            this._serviceInvocationProcessors.forEach(p -> p.onInvoke(header, method, service));
            result = method.invoke(service, parameters);
        }
        finally {
            this._serviceInvocationProcessors.forEach(p -> p.afterInvoke(header, method, service));
        }
        Date endTime = Calendar.getInstance().getTime();
        long diffs = endTime.getTime() - startTime.getTime();
        DWServiceContext.getContext().pushDuration(diffs);
        return result;
    }

    public boolean supportAsyncInvoke(DWCommand command, Map<String, Object> profile) throws Exception {
        String groupName = command.getModuleName();
        String serviceName = command.getServiceName();
        String methodName = command.getMethodName();
        DWDefaultParameters parameters = new DWDefaultParameters(command.getParameters());
        if (groupName == null) {
            throw new IllegalArgumentException("groupName is null!");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName is null!");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("methodName is null!");
        }
        if (profile == null) {
            throw new IllegalArgumentException("profile is null!");
        }
        DWHeader header = this.getDWHeader(groupName, serviceName);
        if (header == null) {
            throw new DWHeaderNotFoundException(groupName, serviceName);
        }
        DWMethod method = this.getDWMethod(header, methodName, parameters);
        if (method == null) {
            throw new DWMethodNotFoundException(groupName, serviceName, methodName, parameters);
        }
        if (!method.allowAnonymous() && profile.size() == 0) {
            throw new DWMethodNotAllowAnonymousException(groupName, serviceName, methodName, parameters);
        }
        Object service = this.getService(header, method);
        return service instanceof DWAsyncSupportService;
    }

    public DWHeader getDWHeader(String groupName, String serviceName) {
        if (groupName == null) {
            throw new IllegalArgumentException("groupName is null!");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName is null!");
        }
        return this._headerRepository.getHeader(groupName, serviceName);
    }

    public DWMethod getDWMethod(DWHeader header, String methodName, DWParameters parameters) {
        if (header == null) {
            throw new IllegalArgumentException("header is null!");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("methodName is null!");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("parameters is null!");
        }
        DWSimpleServiceLocationInfo location = new DWSimpleServiceLocationInfo(header, methodName, parameters);
        DWTargetAPI api = this._headerRepository.getAPI((DWServiceLocationInfo)location);
        return api == null ? null : api.getMethod();
    }

    public DWTargetAPI getAPI(DWServiceLocationInfo locationInfo) {
        return this._headerRepository.getAPI(locationInfo);
    }

    public DWServiceInfo getServiceInfo(String groupName, String serviceName) {
        return this._serviceRepository.getServiceInfo(groupName, serviceName);
    }

    public Object getService(DWHeader header, DWMethod method) throws Exception {
        if (header == null) {
            throw new IllegalArgumentException();
        }
        return this._serviceRepository.getService(header, method);
    }

    public void invokeDWOnloadMethods(String groupName) throws Exception {
        List<DWHeader> headers = this._headerRepository.getHeaders(groupName);
        this.invokeDWOnloadMethods(headers);
    }

    public void invokeDWOnloadMethods() throws Exception {
        List<DWHeader> headers = this._headerRepository.getAllHeader();
        this.invokeDWOnloadMethods(headers);
    }

    private void invokeDWOnloadMethods(List<DWHeader> headers) throws Exception {
        ArrayList checkedInterfaceList = new ArrayList();
        Map profile = DWServiceContext.getContext().getProfile() == null ? Collections.emptyMap() : DWServiceContext.getContext().getProfile();
        for (DWHeader header : headers) {
            if (checkedInterfaceList.contains(header.getServiceType())) continue;
            checkedInterfaceList.add(header.getServiceType());
            for (List<DWMethod> methods : header.getDWMethods().values()) {
                for (DWMethod m : methods) {
                    if (!m.getMethod().isAnnotationPresent(DWOnLoad.class)) continue;
                    DWDefaultParameters defaultParameters = new DWDefaultParameters();
                    for (Parameter param : m.getMethod().getParameters()) {
                        defaultParameters.put(param.getName(), null);
                    }
                    this.invoke(header.getModuleName(), header.getServiceName(), m.getMethodName(), defaultParameters, profile);
                }
            }
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        try {
            Map param = (Map)arg;
            String moduleName = param.getOrDefault("moduleName", "");
            this.refresh(moduleName);
            this.invokeDWOnloadMethods(moduleName);
        }
        catch (Exception e) {
            _log.error((Object)e);
        }
    }

    public void refresh() {
        if (this._serviceLookupProcessor != null) {
            this._serviceLookupProcessor.process();
        }
    }

    public void refresh(String groupName) {
        if (this._serviceLookupProcessor != null) {
            this._serviceLookupProcessor.process(groupName);
        }
    }

    private long logInvoke(String groupName, String serviceName, String methodName, DWParameters parameters) {
        String[] names;
        StringBuilder invokeMessage = new StringBuilder();
        long timestamp = System.currentTimeMillis();
        long threadId = Thread.currentThread().getId();
        invokeMessage.append(">invoke[").append(timestamp).append("]").append("{").append(threadId).append("}").append(">").append(groupName).append(".").append(serviceName).append(".").append(methodName).append("(");
        if (parameters != null && (names = parameters.getNames()) != null) {
            for (int i = 0; i < names.length; ++i) {
                invokeMessage.append(names[i]);
                if (i == names.length - 1) continue;
                invokeMessage.append(", ");
            }
        }
        invokeMessage.append(")");
        invokeMessage.append(" input: ").append(parameters == null ? "null" : parameters.toString());
        _log.info((Object)invokeMessage.toString());
        return timestamp;
    }

    private void logResult(long invokeTimestamp, Object result) {
        StringBuilder resultMessage = new StringBuilder();
        resultMessage.append(">result[").append(invokeTimestamp).append("]>").append(result);
        _log.info((Object)resultMessage.toString());
    }

    private void logException(long invokeTimestamp, Throwable e) {
        StringBuffer exceptionMessage = new StringBuffer();
        exceptionMessage.append(">Exception[").append(invokeTimestamp).append("]>");
        _log.error((Object)exceptionMessage.toString(), e);
    }

    static {
        hotDeploy = true;
    }

    @Deprecated
    static enum EaiMapType {
        method,
        header;

    }

    @Deprecated
    static enum EaiTargetType {
        service,
        callback;

    }
}

