/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.serializer;

import com.digiwin.app.container.exceptions.DWSingletonAlreadyExistsException;
import com.digiwin.app.data.DWRowHashMap;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DWRowHashMapSerializer
implements JsonSerializer<DWRowHashMap> {
    private static DWRowHashMapSerializer singleton;

    public DWRowHashMapSerializer() {
        if (singleton != null) {
            throw new DWSingletonAlreadyExistsException((Object)this);
        }
        singleton = this;
        DWGsonProvider.registerTypeAdapter(DWRowHashMap.class, (Object)this);
    }

    public JsonElement serialize(DWRowHashMap src, Type typeOfSrc, JsonSerializationContext context) {
        Map<String, Object> childMap = src.entrySet().stream().filter(item -> item.getValue() instanceof List).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (childMap.size() > 0) {
            childMap.entrySet().stream().forEach(item -> src.remove(item.getKey()));
            src.put((Object)"child", childMap);
        }
        HashMap cloneMap = new HashMap(src);
        return context.serialize(cloneMap);
    }
}

