/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data;

import com.digiwin.app.dao.serializer.DWRowHashMapSerializer;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.json.gson.DWGsonProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DWDataSetDeserializeUtil {
    public static DWDataSet create(Map<String, Object> sourceMap) {
        DWDataSet dataset = new DWDataSet();
        for (Map.Entry<String, Object> item : sourceMap.entrySet()) {
            DWDataSetDeserializeUtil.buildDataTable(dataset, item);
        }
        return dataset;
    }

    private static DWDataTable buildDataTable(DWDataSet dataset, Map.Entry<String, Object> sourceMapItem) {
        DWDataTable dataTable = null;
        List<Map<String, Object>> orgRows = null;
        Object value = sourceMapItem.getValue();
        if (value == null) {
            orgRows = new ArrayList();
        } else if (value instanceof List) {
            orgRows = (List)value;
        } else if (value instanceof Map) {
            orgRows = new ArrayList();
            orgRows.add((Map)value);
        } else {
            throw new DWDataException("13028", "Can not convert source map to DWDataTable!!!");
        }
        String tableName = sourceMapItem.getKey();
        dataTable = dataset.getTable(tableName, false);
        if (dataTable == null) {
            dataTable = dataset.newTable(tableName);
        }
        boolean hasDWRowHashMapSerializer = DWGsonProvider.hasAdapterInstance(DWRowHashMapSerializer.class);
        DWDataSetDeserializeUtil.buildDataRow(dataTable, orgRows, hasDWRowHashMapSerializer);
        return dataTable;
    }

    private static void buildDataRow(DWDataTable dataTable, List<Map<String, Object>> orgRows, boolean hasDWRowHashMapSerializer) {
        for (Map<String, Object> orgRow : orgRows) {
            DWDataRow dataRow = dataTable.newRow();
            if (hasDWRowHashMapSerializer && orgRow.containsKey("child") && orgRow.get("child") instanceof Map) {
                Map childMap = (Map)orgRow.get("child");
                orgRow.remove("child");
                orgRow.putAll(childMap);
            }
            dataRow.importOrgData(orgRow);
        }
    }
}

