/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.serializer;

import com.digiwin.app.container.exceptions.DWSingletonAlreadyExistsException;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetDeserializeUtil;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DWDataSetDeserializer
implements JsonDeserializer<DWDataSet> {
    private static DWDataSetDeserializer singleton;

    public DWDataSetDeserializer() {
        if (singleton != null) {
            throw new DWSingletonAlreadyExistsException((Object)this);
        }
        singleton = this;
        DWGsonProvider.registerTypeAdapter(DWDataSet.class, (Object)this);
    }

    public DWDataSet deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        HashMap<String, List> sourceMap;
        if (json instanceof JsonArray) {
            JsonArray jsonArray = json.getAsJsonArray();
            List masterDataList = (List)context.deserialize((JsonElement)jsonArray, List.class);
            sourceMap = new HashMap<String, List>();
            sourceMap.put("$unassigned", masterDataList);
        } else {
            JsonObject jsonObject = json.getAsJsonObject();
            sourceMap = (HashMap<String, List>)context.deserialize((JsonElement)jsonObject, Map.class);
        }
        DWDataSet dataset = DWDataSetDeserializeUtil.create((Map<String, Object>)sourceMap);
        return dataset;
    }
}

