/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data;

import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataRowState;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.exceptions.DWDataInvalidOperationException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class DWDataRowCollection
implements Serializable,
Iterable<DWDataRow> {
    private transient DWDataTable dataTable;
    private List<DWDataRow> rows;
    private List<DWDataRow> removedRows;

    protected DWDataRowCollection(DWDataTable owner) {
        this.dataTable = owner;
        this.rows = new ArrayList<DWDataRow>();
        this.removedRows = new ArrayList<DWDataRow>();
    }

    protected DWDataRowCollection(DWDataTable owner, List<Map<String, Object>> orgRows) {
        this(owner);
        this.importRowOrgDatas(orgRows);
    }

    protected Collection<DWDataRow> importRowOrgDatas(List<Map<String, Object>> orgRows) {
        return this.importRowOrgDatas(orgRows, null);
    }

    protected Collection<DWDataRow> importRowOrgDatas(List<Map<String, Object>> orgRows, DWDataRow parentRow) {
        if (orgRows == null) {
            return Collections.emptyList();
        }
        ArrayList<DWDataRow> newRows = new ArrayList<DWDataRow>();
        for (Map<String, Object> orgRow : orgRows) {
            DWDataRow newRow = this.newRow();
            newRow.setParentRow(parentRow);
            newRow.importOrgData(orgRow);
            newRows.add(newRow);
        }
        return newRows;
    }

    public DWDataRow get(int index) {
        return this.rows.get(index);
    }

    protected void setOwner(DWDataTable dataTable) {
        this.dataTable = dataTable;
    }

    protected DWDataTable getOwner() {
        return this.dataTable;
    }

    protected DWDataSet getDataSet() {
        if (this.dataTable != null && this.dataTable.getOwner() != null) {
            return this.dataTable.getOwner().getOwner();
        }
        return null;
    }

    protected DWDataRow createDataRowInstance() {
        DWDataRow row = new DWDataRow(this);
        row.set("$state", (Object)"C");
        return row;
    }

    public DWDataRow newRow() {
        DWDataRow row = this.createDataRowInstance();
        this.rows.add(row);
        this.getDataSet().setDirty();
        return row;
    }

    @Override
    public Iterator<DWDataRow> iterator() {
        return this.rows.iterator();
    }

    public Stream<DWDataRow> stream() {
        return this.rows.stream();
    }

    public Iterator<DWDataRow> getIteratorOfRemovedRows() {
        return this.removedRows.iterator();
    }

    public int indexOf(DWDataRow row) {
        return this.rows.indexOf(row);
    }

    public int size() {
        return this.rows.size();
    }

    public void deleteAt(int rowIndex) {
        DWDataRow row = this.rows.get(rowIndex);
        this.delete(row);
    }

    protected void delete(DWDataRow row) {
        boolean success = this.rows.remove(row);
        if (!success) {
            throw new DWDataInvalidOperationException(this, row, "delete");
        }
        row.set("$state", (Object)"D");
        this.removedRows.add(row);
    }

    protected void persist(DWDataRow row) {
        if (this.removedRows.contains(row) && DWDataRowState.isManaged(row)) {
            this.removedRows.remove(row);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName()).append("->").append(System.lineSeparator());
        result.append(">>> row list (").append(this.size()).append(")").append(System.lineSeparator()).append(this.rows).append(System.lineSeparator()).append(">>> removed list (").append(this.removedRows.size()).append(")").append(System.lineSeparator()).append(this.removedRows);
        return result.toString();
    }
}

